/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import javax.swing.JFrame;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.old.EclipseSource;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.old.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.EditableSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.nls.AbstractNlsTest;
import org.eclipse.wb.tests.designer.core.nls.NlsTestUtils;
import org.junit.Test;

public class SourceEclipseOldTest
extends AbstractNlsTest {
    @Test
    public void test_constructorWithoutAccessor() throws Exception {
        SourceEclipseOldTest.setFileContentSrc("test/messages.properties", SourceEclipseOldTest.getSourceDQ("frame.title=My JFrame"));
        SourceEclipseOldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EclipseSource source = new EclipseSource((JavaInfo)frame, null, "test.messages");
        IEditableSource editableSource = source.getEditable();
        SourceEclipseOldTest.assertEquals((Object)"My JFrame", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title"));
        SourceParameters parameters = new SourceParameters();
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        parameters.m_accessorSourceFolder = javaProject.findPackageFragmentRoot((IPath)new Path("/TestProject/src"));
        parameters.m_accessorPackage = javaProject.findPackageFragment((IPath)new Path("/TestProject/src/test"));
        parameters.m_accessorPackageName = parameters.m_accessorPackage.getElementName();
        parameters.m_accessorClassName = "Messages";
        parameters.m_accessorFullClassName = "test.Messages";
        parameters.m_accessorExists = false;
        parameters.m_propertySourceFolder = parameters.m_accessorSourceFolder;
        parameters.m_propertyPackage = parameters.m_accessorPackage;
        parameters.m_propertyFileName = "messages.properties";
        parameters.m_propertyBundleName = "test.messages";
        parameters.m_propertyFileExists = false;
        SourceDescription sourceDescription = SourceEclipseOldTest.getSourceDescription((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        editableSupport.addSource(editableSource, sourceDescription, (Object)parameters);
        support.applyEditable(editableSupport);
        SourceEclipseOldTest.assertTrue((boolean)SourceEclipseOldTest.getFileSrc("/test/Messages.java").exists());
        String newProperties = SourceEclipseOldTest.getFileContentSrc("test/messages.properties");
        SourceEclipseOldTest.assertFalse((boolean)newProperties.contains("#Eclipse messages class"));
        SourceEclipseOldTest.assertTrue((boolean)newProperties.contains("frame.title=My JFrame"));
    }

    @Test
    public void test_slashBundleName() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, "test/messages", false);
        SourceEclipseOldTest.setFileContentSrc("test/messages.properties", SourceEclipseOldTest.getSourceDQ("frame.title=My JFrame"));
        SourceEclipseOldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.getString('frame.title'));", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceEclipseOldTest.assertEquals((long)1L, (long)support.getSources().length);
        frame.refresh();
        try {
            SourceEclipseOldTest.assertEquals((Object)"My JFrame", (Object)((JFrame)frame.getObject()).getTitle());
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_qualifiedName() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        SourceEclipseOldTest.setFileContentSrc("test/messages.properties", SourceEclipseOldTest.getSourceDQ("frame.title=My JFrame"));
        SourceEclipseOldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(test.Messages.getString('frame.title'));", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceEclipseOldTest.assertEquals((long)1L, (long)support.getSources().length);
        frame.refresh();
        try {
            SourceEclipseOldTest.assertEquals((Object)"My JFrame", (Object)((JFrame)frame.getObject()).getTitle());
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_badPossible_1() throws Exception {
        SourceEclipseOldTest.setFileContentSrc("test/Messages.java", SourceEclipseOldTest.getSourceDQ("package test;", "public class Messages {", "  private static final String BUNDLE_NAME2 = 'test.messages'; //$NON-NLS-1$", "}"));
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editable = support.getEditable();
        SourceEclipseOldTest.assertEquals((long)0L, (long)editable.getEditableSources().size());
    }

    @Test
    public void test_badPossible_2() throws Exception {
        SourceEclipseOldTest.setFileContentSrc("test/Messages.java", SourceEclipseOldTest.getSourceDQ("package test;", "public class Messages {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "}"));
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editable = support.getEditable();
        SourceEclipseOldTest.assertEquals((long)0L, (long)editable.getEditableSources().size());
    }

    @Test
    public void test_badSource_1() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(getString2('frame.title'));", "  }", "  private static String getString2(String key) {", "    return key;", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceEclipseOldTest.assertEquals((long)0L, (long)support.getSources().length);
    }

    @Test
    public void test_badSource_2() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(getString('frame.title'));", "  }", "  private static String getString(String key) {", "    return key;", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceEclipseOldTest.assertEquals((long)0L, (long)support.getSources().length);
    }

    @Test
    public void test_addSource() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        IEditableSource editableSource = NlsTestUtils.createEmptyEditable("messages");
        SourceDescription sourceDescription = SourceEclipseOldTest.getSourceDescription((JavaInfo)frame);
        SourceParameters parameters = new SourceParameters();
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        parameters.m_accessorSourceFolder = javaProject.findPackageFragmentRoot((IPath)new Path("/TestProject/src"));
        parameters.m_accessorPackage = javaProject.findPackageFragment((IPath)new Path("/TestProject/src/test"));
        parameters.m_accessorPackageName = parameters.m_accessorPackage.getElementName();
        parameters.m_accessorClassName = "Messages";
        parameters.m_accessorFullClassName = "test.Messages";
        parameters.m_accessorExists = false;
        parameters.m_propertySourceFolder = parameters.m_accessorSourceFolder;
        parameters.m_propertyPackage = parameters.m_accessorPackage;
        parameters.m_propertyFileName = "messages.properties";
        parameters.m_propertyBundleName = "test.messages";
        parameters.m_propertyFileExists = false;
        parameters.m_withDefaultValue = false;
        editableSupport.addSource(editableSource, sourceDescription, (Object)parameters);
        support.applyEditable((IEditableSupport)editableSupport);
        SourceEclipseOldTest.assertEquals((Object)SourceEclipseOldTest.getSourceDQ("package test;", "", "import java.beans.Beans;", "import java.util.MissingResourceException;", "import java.util.ResourceBundle;", "", "public class Messages {", "  ////////////////////////////////////////////////////////////////////////////", "  //", "  // Constructor", "  //", "  ////////////////////////////////////////////////////////////////////////////", "  private Messages() {", "    // do not instantiate", "  }", "  ////////////////////////////////////////////////////////////////////////////", "  //", "  // Bundle access", "  //", "  ////////////////////////////////////////////////////////////////////////////", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  private static final ResourceBundle RESOURCE_BUNDLE = loadBundle();", "  private static ResourceBundle loadBundle() {", "    return ResourceBundle.getBundle(BUNDLE_NAME);", "  }", "  ////////////////////////////////////////////////////////////////////////////", "  //", "  // Strings access", "  //", "  ////////////////////////////////////////////////////////////////////////////", "  public static String getString(String key) {", "    try {", "      ResourceBundle bundle = Beans.isDesignTime() ? loadBundle() : RESOURCE_BUNDLE;", "      return bundle.getString(key);", "    } catch (MissingResourceException e) {", "      return '!' + key + '!';", "    }", "  }", "}"), (Object)StringUtils.replace((String)SourceEclipseOldTest.getFileContentSrc("test/Messages.java"), (String)"\r\n", (String)"\n"));
        SourceEclipseOldTest.assertTrue((boolean)SourceEclipseOldTest.getFileSrc("test/messages.properties").exists());
    }
}

