/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalReuseVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.Test;

public class LocalReuseTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      button = new JButton('button 1');", "      add(button);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        LocalReuseTest.assertEquals((long)2L, (long)panel.getChildrenComponents().size());
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        LocalReuseTest.assertTrue((boolean)(variableSupport instanceof LocalReuseVariableSupport));
        LocalReuseTest.assertTrue((boolean)variableSupport.hasName());
        LocalReuseTest.assertEquals((Object)"local-reused: button", (Object)variableSupport.toString());
        LocalReuseTest.assertEquals((Object)"button", (Object)variableSupport.getName());
        NodeTarget target = LocalReuseTest.getNodeStatementTarget((JavaInfo)panel, false, 1);
        LocalReuseTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalReuseTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        LocalReuseTest.assertTrue((boolean)variableSupport.canConvertLocalToField());
        LocalReuseTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            LocalReuseTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        button = (JavaInfo)panel.getChildrenComponents().get(1);
        variableSupport = button.getVariableSupport();
        LocalReuseTest.assertTrue((boolean)(variableSupport instanceof LocalReuseVariableSupport));
        LocalReuseTest.assertEquals((Object)"button", (Object)variableSupport.getName());
    }

    @Test
    public void test_setName_justField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      button = new JButton('button 1');", "      add(button);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        button.getVariableSupport().setName("abc");
        LocalReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        LocalReuseTest.assertAST(this.m_lastEditor);
        LocalReuseTest.assertEquals((Object)this.getTestSource("public class Test extends JPanel {", "  private JButton abc;", "  public Test() {", "    JButton button;", "    {", "      abc = new JButton('button 1');", "      add(abc);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_setName_split() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('button 1');", "    add(button);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        button.getVariableSupport().setName("abc");
        LocalReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton abc;", "  public Test() {", "    JButton button;", "    abc = new JButton('button 1');", "    add(abc);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
    }

    @Test
    public void test_getReferenceExpression_local_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      button = new JButton('button 1');", "      add(button);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        NodeTarget target = LocalReuseTest.getNodeStatementTarget((JavaInfo)panel, false, 1, 1);
        LocalReuseTest.assertEquals((Object)"button", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalReuseVariableSupport));
        LocalReuseTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_getReferenceExpression_local_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      button = new JButton('button 1');", "      add(button);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        NodeTarget target = LocalReuseTest.getNodeStatementTarget((JavaInfo)panel, false, 1);
        LocalReuseTest.assertEquals((Object)"button", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalReuseVariableSupport));
        LocalReuseTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_getReferenceExpression_remote() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      button = new JButton('button 1');", "      add(button);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        NodeTarget target = LocalReuseTest.getNodeStatementTarget((JavaInfo)panel, false, 2);
        LocalReuseTest.assertEquals((Object)"button_1", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalReuseTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        LocalReuseTest.assertEquals((Object)this.getTestSource("public class Test extends JPanel {", "  private JButton button_1;", "  public Test() {", "    JButton button;", "    {", "      button_1 = new JButton('button 1');", "      add(button_1);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_toField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      button = new JButton('button 1');", "      add(button);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getVariableSupport().convertLocalToField();
        VariableSupport variableSupport = button.getVariableSupport();
        LocalReuseTest.assertTrue((boolean)(variableSupport instanceof FieldUniqueVariableSupport));
        LocalReuseTest.assertEquals((Object)"button_1", (Object)variableSupport.getName());
        LocalReuseTest.assertEquals((Object)this.getTestSource("public class Test extends JPanel {", "  private JButton button_1;", "  public Test() {", "    JButton button;", "    {", "      button_1 = new JButton('button 1');", "      add(button_1);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_setType_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      button = new JButton('button 1');", "      add(button);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalReuseVariableSupport variable = (LocalReuseVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    {", "      JTextField button_1 = new JButton('button 1');", "      add(button_1);", "    }", "    {", "      button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        variable = (LocalUniqueVariableSupport)button.getVariableSupport();
        LocalReuseTest.assertEquals((Object)"button_1", (Object)variable.getName());
    }

    @Test
    public void test_setType_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    //", "    button = new JButton('button 1');", "    add(button);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalReuseVariableSupport variable = (LocalReuseVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    //", "    JTextField button_1 = new JButton('button 1');", "    add(button_1);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
        variable = (LocalUniqueVariableSupport)button.getVariableSupport();
        LocalReuseTest.assertEquals((Object)"button_1", (Object)variable.getName());
    }

    @Test
    public void test_setType_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('button 1');", "    add(button);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalReuseVariableSupport variable = (LocalReuseVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    JTextField button_1 = new JButton('button 1');", "    add(button_1);", "    //", "    button = new JButton('button 2');", "    add(button);", "  }", "}");
        variable = (LocalUniqueVariableSupport)button.getVariableSupport();
        LocalReuseTest.assertEquals((Object)"button_1", (Object)variable.getName());
    }
}

