/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.variable.EmptyInvocationVariableSupport;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldInitializerVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.Test;

public class EmptyTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    add(new JButton('button'));", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).hasSize(1);
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        EmptyVariableSupport variableSupport = (EmptyVariableSupport)button.getVariableSupport();
        EmptyTest.assertEquals((Object)"empty", (Object)variableSupport.toString());
        EmptyTest.assertEquals((Object)"(no variable)", (Object)variableSupport.getTitle());
        EmptyTest.assertTrue((boolean)variableSupport.isDefault());
        EmptyTest.assertEquals((Object)"new JButton(\"button\")", (Object)this.m_lastEditor.getSource((ASTNode)variableSupport.getInitializer()));
        EmptyTest.assertTrue((boolean)variableSupport.hasName());
        EmptyTest.assertNull((Object)variableSupport.getName());
        EmptyTest.assertTrue((boolean)variableSupport.canConvertLocalToField());
        EmptyTest.assertTrue((boolean)variableSupport.canConvertFieldToLocal());
    }

    @Test
    public void test_setName() throws Exception {
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    add(new JButton('button'));", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        variableSupport.setName("abc");
        EmptyTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        this.assertEditor("public final class Test extends JPanel {", "  public Test() {", "    JButton abc = new JButton('button');", "    add(abc);", "  }", "}");
        EmptyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(abc)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: abc} {/new JButton('button')/ /add(abc)/}");
    }

    @Test
    public void test_getAccessExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        EmptyTest.assertTrue((boolean)variableSupport.hasExpression(null));
        NodeTarget target = EmptyTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        EmptyTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        EmptyTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_toLocal() throws Exception {
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    add(new JButton('button'));", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        variableSupport.convertFieldToLocal();
        EmptyTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        this.assertEditor("public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('button');", "    add(button);", "  }", "}");
    }

    @Test
    public void test_toField() throws Exception {
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    add(new JButton('button'));", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        variableSupport.convertLocalToField();
        EmptyTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public final class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton('button');", "    add(button);", "  }", "}");
    }

    @Test
    public void test_materialize_wasInStatement() throws Exception {
        this.prepare_genericButton();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    add(new Button<String>());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final EmptyVariableSupport variableSupport = (EmptyVariableSupport)button.getVariableSupport();
        final boolean[] broadcastNotified = new boolean[1];
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void variable_emptyMaterializeBefore(EmptyVariableSupport _variableSupport) throws Exception {
                EmptyTest.assertSame((Object)variableSupport, (Object)_variableSupport);
                broadcastNotified[0] = true;
            }
        });
        variableSupport.materialize();
        EmptyTest.assertTrue((boolean)broadcastNotified[0]);
        this.assertEditor("public final class Test extends JPanel {", "  public Test() {", "    Button<String> button = new Button<String>();", "    add(button);", "  }", "}");
        EmptyTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
    }

    @Test
    public void test_materialize_wasInField() throws Exception {
        this.prepare_genericButton();
        this.parseContainer("public final class Test extends JPanel {", "  private JScrollPane panel = new JScrollPane(new Button<String>());", "  public Test() {", "    add(panel);", "  }", "}");
        ContainerInfo panel = (ContainerInfo)EmptyTest.getJavaInfoByName("panel");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final EmptyVariableSupport variableSupport = (EmptyVariableSupport)button.getVariableSupport();
        final boolean[] broadcastNotified = new boolean[1];
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void variable_emptyMaterializeBefore(EmptyVariableSupport _variableSupport) throws Exception {
                EmptyTest.assertSame((Object)variableSupport, (Object)_variableSupport);
                broadcastNotified[0] = true;
            }
        });
        variableSupport.materialize();
        EmptyTest.assertTrue((boolean)broadcastNotified[0]);
        this.assertEditor("public final class Test extends JPanel {", "  private Button<String> button = new Button<String>();", "  private JScrollPane panel = new JScrollPane(button);", "  public Test() {", "    add(panel);", "  }", "}");
        EmptyTest.assertInstanceOf(FieldInitializerVariableSupport.class, (Object)button.getVariableSupport());
    }

    @Test
    public void test_materialize_removeParenthesizedExpression() throws Exception {
        EmptyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "    container.add(this);", "  }", "}"));
        EmptyTest.setFileContentSrc("test/MyButton.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        EmptyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    (new MyButton(this)).setEnabled(false);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        EmptyVariableSupport variableSupport = (EmptyVariableSupport)button.getVariableSupport();
        variableSupport.materialize();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton myButton = new MyButton(this);", "    myButton.setEnabled(false);", "  }", "}");
        EmptyTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
    }

    @Test
    public void test_target() throws Exception {
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    add(new JButton('button'));", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        EmptyTest.assertTarget(target, null, EmptyTest.getStatement((JavaInfo)panel, 0), false);
        this.assertEditor("public final class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('button');", "    add(button);", "  }", "}");
        EmptyTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
    }

    @Test
    public void test_ensureInstanceReadyAt() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('1'));", "    add(new JButton('2'));", "  }", "}");
        panel.refresh();
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        flowLayout.move(button_2, button_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('2');", "    add(button);", "    add(new JButton('1'));", "  }", "}");
    }

    @Test
    public void test_add() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ComponentInfo button = EmptyTest.createJButton();
        JavaInfoUtils.add((JavaInfo)button, (VariableSupport)new EmptyInvocationVariableSupport((JavaInfo)button, "%parent%.add(%child%)", 0), (StatementGenerator)PureFlatStatementGenerator.INSTANCE, (AssociationObject)AssociationObjects.invocationChildNull(), (JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
    }

    @Test
    public void test_materialize_noOuterExpression() throws Exception {
        EmptyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton<T> extends JButton {", "  public MyButton(Container container) {", "  }", "}"));
        EmptyTest.setFileContentSrc("test/MyButton.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        EmptyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton<String>(this);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NodeTarget target = EmptyTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        StatementTarget statementTarget = target.getStatementTarget();
        EmptyTest.assertFalse((boolean)statementTarget.isBefore());
        Statement targetStatement_old = statementTarget.getStatement();
        EmptyTest.assertEquals((Object)"new MyButton<String>(this);", (Object)this.m_lastEditor.getSource((ASTNode)targetStatement_old));
        EmptyTest.assertEquals((Object)"myButton", (Object)button.getVariableSupport().getReferenceExpression(target));
        EmptyTest.assertFalse((boolean)statementTarget.isBefore());
        Statement targetStatement_new = statementTarget.getStatement();
        EmptyTest.assertNotSame((Object)targetStatement_old, (Object)targetStatement_new);
        EmptyTest.assertEquals((Object)"MyButton<String> myButton = new MyButton<String>(this);", (Object)this.m_lastEditor.getSource((ASTNode)targetStatement_new));
        EmptyTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton<String> myButton = new MyButton<String>(this);", "  }", "}");
    }

    @Test
    public void test_move_noOuterExpression() throws Exception {
        EmptyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container, int value) {", "  }", "}"));
        EmptyTest.setFileContentSrc("test/MyButton.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "      <parameter type='int'/>", "    </constructor>", "  </constructors>", "</component>"));
        EmptyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this, 0);", "    new MyButton(this, 1);", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        flowLayout.move(button_1, button_0);
        EmptyTest.assertInstanceOf(EmptyVariableSupport.class, (Object)button_1.getVariableSupport());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this, 1);", "    new MyButton(this, 0);", "  }", "}");
    }

    @Test
    public void test_returnInitializer_setProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(createButton());", "  }", "  private JButton createButton() {", "    return new JButton();", "  }", "}");
        EmptyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(createButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/new JButton()/ /add(createButton())/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("text").setValue((Object)"text");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(createButton());", "  }", "  private JButton createButton() {", "    JButton button = new JButton();", "    button.setText('text');", "    return button;", "  }", "}");
    }

    @Test
    public void test_returnInitializer_addChild() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(createPanel());", "  }", "  private JPanel createPanel() {", "    return new JPanel();", "  }", "}");
        ContainerInfo subPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)subPanel.getLayout();
        ComponentInfo button = EmptyTest.createJButton();
        flowLayout.add(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(createPanel());", "  }", "  private JPanel createPanel() {", "    JPanel panel = new JPanel();", "    {", "      JButton button = new JButton();", "      panel.add(button);", "    }", "    return panel;", "  }", "}");
    }

    @Test
    public void test_noOuterExpression_setProperty_afterCreation() throws Exception {
        EmptyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "  }", "}"));
        EmptyTest.setFileContentSrc("test/MyButton.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "  <!-- METHODS ORDER -->", "  <method-order>", "    <default order='afterCreation'/>", "  </method-order>", "</component>"));
        EmptyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("text").setValue((Object)"Some text");
        EmptyTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton myButton = new MyButton(this);", "    myButton.setText('Some text');", "  }", "}");
    }

    @Test
    public void test_noOuterExpression_setProperty_afterAssociation() throws Exception {
        EmptyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "  }", "}"));
        EmptyTest.setFileContentSrc("test/MyButton.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "  <!-- METHODS ORDER -->", "  <method-order>", "    <default order='afterAssociation'/>", "  </method-order>", "</component>"));
        EmptyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("text").setValue((Object)"Some text");
        EmptyTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)button.getVariableSupport());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton myButton = new MyButton(this);", "    myButton.setText('Some text');", "  }", "}");
    }

    @Test
    public void test_moveWithChildren() throws Exception {
        EmptyTest.setFileContentSrc("test/MyMenuItem.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyMenuItem extends JPanel {", "}"));
        EmptyTest.setFileContentSrc("test/MyMenuItem.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        EmptyTest.setFileContentSrc("test/MyMenuBar.java", this.getTestSource("public class MyMenuBar extends JPanel {", "  public MyMenuItem addItem(String text, Component content) {", "    MyMenuItem item = new MyMenuItem();", "    add(item);", "    item.add(content);", "    return item;", "  }", "}"));
        EmptyTest.setFileContentSrc("test/MyMenuBar.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- METHODS -->", "  <methods>", "    <method name='addItem'>", "      <parameter type='java.lang.String'/>", "      <parameter type='java.awt.Component'>", "        <tag name='implicitFactory.child' value='true'/>", "      </parameter>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "</component>"));
        EmptyTest.waitForAutoBuild();
        ContainerInfo menuBar = this.parseContainer("public class Test extends MyMenuBar {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      addItem('item_1', button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      addItem('item_2', button_2);", "    }", "  }", "}");
        EmptyTest.assertHierarchy("{this: test.MyMenuBar} {this} {/addItem('item_1', button_1)/ /addItem('item_2', button_2)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {implicit-factory} {empty} {/addItem('item_1', button_1)/}", "    {new: javax.swing.JButton} {local-unique: button_1} {/new JButton()/ /addItem('item_1', button_1)/}", "  {implicit-factory} {empty} {/addItem('item_2', button_2)/}", "    {new: javax.swing.JButton} {local-unique: button_2} {/new JButton()/ /addItem('item_2', button_2)/}");
        ContainerInfo item_1 = (ContainerInfo)menuBar.getChildrenComponents().get(0);
        ContainerInfo item_2 = (ContainerInfo)menuBar.getChildrenComponents().get(1);
        FlowLayoutInfo menuBarLayout = (FlowLayoutInfo)menuBar.getLayout();
        menuBarLayout.move((ComponentInfo)item_2, (ComponentInfo)item_1);
        this.assertEditor("public class Test extends MyMenuBar {", "  public Test() {", "    {", "      JButton button_2 = new JButton();", "      MyMenuItem myMenuItem = addItem('item_2', button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      addItem('item_1', button_1);", "    }", "  }", "}");
    }

    private void prepare_genericButton() throws Exception {
        EmptyTest.setFileContentSrc("test/Button.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Button<T> extends JButton {", "}"));
        EmptyTest.setFileContentSrc("test/Button.wbp-component.xml", EmptyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.Button<%keyType%>()]]></source>", "  </creation>", "</component>"));
        EmptyTest.waitForAutoBuild();
    }
}

