/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import org.eclipse.wb.internal.core.model.util.predicate.AlwaysPredicate;
import org.eclipse.wb.internal.core.model.util.predicate.ComponentSubclassPredicate;
import org.eclipse.wb.internal.core.model.util.predicate.ExpressionPredicate;
import org.eclipse.wb.internal.core.model.util.predicate.SubclassPredicate;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class PredicatesTest
extends SwingModelTest {
    @Test
    public void test_AlwaysPredicate_true() throws Exception {
        AlwaysPredicate predicate = new AlwaysPredicate(true);
        PredicatesTest.assertTrue((boolean)predicate.test("yes"));
        PredicatesTest.assertTrue((boolean)predicate.test(this));
        PredicatesTest.assertTrue((boolean)predicate.test(null));
    }

    @Test
    public void test_AlwaysPredicate_false() throws Exception {
        AlwaysPredicate predicate = new AlwaysPredicate(false);
        PredicatesTest.assertFalse((boolean)predicate.test("yes"));
        PredicatesTest.assertFalse((boolean)predicate.test(this));
        PredicatesTest.assertFalse((boolean)predicate.test(null));
    }

    @Test
    public void test_SubclassPredicate() throws Exception {
        SubclassPredicate predicate = new SubclassPredicate(String.class);
        PredicatesTest.assertTrue((boolean)predicate.test("yes"));
        PredicatesTest.assertFalse((boolean)predicate.test(this));
        PredicatesTest.assertTrue((boolean)predicate.test(null));
    }

    @Test
    public void test_ComponentSubclassPredicate() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentSubclassPredicate predicate = new ComponentSubclassPredicate("java.awt.Component");
        PredicatesTest.assertEquals((Object)"java.awt.Component", (Object)predicate.toString());
        PredicatesTest.assertTrue((boolean)predicate.test((Object)panel));
        PredicatesTest.assertFalse((boolean)predicate.test((Object)panel.getLayout()));
        PredicatesTest.assertFalse((boolean)predicate.test((Object)"not JavaInfo"));
    }

    @Test
    public void test_ExpressionPredicate_alwaysTrue() throws Exception {
        ExpressionPredicate predicate = new ExpressionPredicate("true");
        PredicatesTest.assertEquals((Object)"true", (Object)predicate.toString());
        PredicatesTest.assertTrue((boolean)predicate.test(null));
    }

    @Test
    public void test_ExpressionPredicate_alwaysFalse() throws Exception {
        ExpressionPredicate predicate = new ExpressionPredicate("false");
        PredicatesTest.assertFalse((boolean)predicate.test(null));
    }

    @Test
    public void test_ExpressionPredicate_checkLength() throws Exception {
        ExpressionPredicate predicate = new ExpressionPredicate("length() > 5");
        PredicatesTest.assertFalse((boolean)predicate.test("123"));
        PredicatesTest.assertTrue((boolean)predicate.test("123456"));
    }
}

