/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.ConstantSelectionPropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ConstantSelectionPropertyEditorTest
extends SwingModelTest {
    private Shell m_shell;
    private final String m_propertyName = "stringId";
    private Property m_property;
    private ConstantSelectionPropertyEditor m_propertyEditor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_shell = new Shell();
        ConstantSelectionPropertyEditorTest.setFileContentSrc("test/PrefConstants.java", this.getTestSource("public interface PrefConstants {", "  String ID_1 = 'id 1';", "  int ID_2 = 2;", "  int ID_3 = 3;", "  String ID_4 = 'id 4';", "}"));
        ConstantSelectionPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "  public void setStringId(String id) {", "  }", "  public void setStringId2(String id) {", "  }", "  public void setIntId(int id) {", "  }", "}"));
        ConstantSelectionPropertyEditorTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ConstantSelectionPropertyEditorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setStringId(java.lang.String)'>", "    <editor id='constantSelection'>", "      <parameter name='type'>java.lang.String</parameter>", "    </editor>", "  </property>", "  <property id='setStringId2(java.lang.String)'>", "    <editor id='constantSelection'>", "      <parameter name='type'>java.lang.String</parameter>", "    </editor>", "  </property>", "  <property id='setIntId(int)'>", "    <editor id='constantSelection'>", "      <parameter name='type'>int</parameter>", "    </editor>", "  </property>", "</component>"));
        ConstantSelectionPropertyEditorTest.waitForAutoBuild();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.m_shell != null) {
            this.m_shell.dispose();
            this.m_shell = null;
        }
        this.m_property = null;
        this.m_propertyEditor = null;
    }

    private void prepareProperty() throws Exception {
        this.m_property = this.m_lastParseInfo.getPropertyByTitle("stringId");
        this.m_propertyEditor = (ConstantSelectionPropertyEditor)this.m_property.getEditor();
    }

    private String getText() throws Exception {
        this.prepareProperty();
        return (String)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"getText", Property.class, (Object)this.m_property);
    }

    private IField getField() throws Exception {
        this.prepareProperty();
        return (IField)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"getField", GenericProperty.class, (Object)this.m_property);
    }

    private IType getType() throws Exception {
        this.prepareProperty();
        return (IType)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"getType", GenericProperty.class, (Object)this.m_property);
    }

    private List<IField> getFields() throws Exception {
        this.prepareProperty();
        return (List)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"getFields", IType.class, (Object)this.getType());
    }

    private void setField(IField field) throws Exception {
        this.prepareProperty();
        ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"setField", GenericProperty.class, IField.class, (Object)this.m_property, (Object)field);
    }

    private Set<IType> getUsedTypes() throws Exception {
        this.prepareProperty();
        return (Set)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"getUsedTypes", JavaInfo.class, (Object)this.m_lastParseInfo);
    }

    private List<IType> getLocalTypes() throws Exception {
        this.prepareProperty();
        return (List)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"getLocalTypes", JavaInfo.class, (Object)this.m_lastParseInfo);
    }

    @Test
    public void test_utils_noValue() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getField());
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getType());
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getText());
        Assertions.assertThat(this.getFields()).isEmpty();
    }

    @Test
    public void test_utils_notQualifiedName() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setStringId('constant');", "  }", "}");
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getField());
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getType());
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getText());
        Assertions.assertThat(this.getFields()).isEmpty();
    }

    @Test
    public void test_utils_qualifiedName() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setStringId(PrefConstants.ID_1);", "  }", "}");
        IField field = this.getField();
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_1", (Object)field.getElementName());
        IType type = this.getType();
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"test.PrefConstants", (Object)type.getFullyQualifiedName());
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_1", (Object)this.getText());
        List<IField> fields = this.getFields();
        Assertions.assertThat(fields).hasSize(2);
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_1", (Object)fields.get(0).getElementName());
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_4", (Object)fields.get(1).getElementName());
        IType constantsType = m_testProject.getJavaProject().findType("test.PrefConstants");
        IField field2 = constantsType.getField("ID_4");
        ConstantSelectionPropertyEditorTest.assertTrue((boolean)field2.exists());
        this.setField(field2);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setStringId(PrefConstants.ID_4);", "  }", "}");
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_4", (Object)this.getText());
    }

    @Test
    public void test_utils_simpleName_interface() throws Exception {
        this.parseContainer("public class Test extends MyPanel implements PrefConstants {", "  public Test() {", "    setStringId(ID_1);", "  }", "}");
        IField field = this.getField();
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_1", (Object)field.getElementName());
        IType type = this.getType();
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"test.PrefConstants", (Object)type.getFullyQualifiedName());
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_1", (Object)this.getText());
        List<IField> fields = this.getFields();
        Assertions.assertThat(fields).hasSize(2);
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_1", (Object)fields.get(0).getElementName());
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_4", (Object)fields.get(1).getElementName());
        IType constantsType = m_testProject.getJavaProject().findType("test.PrefConstants");
        IField field2 = constantsType.getField("ID_4");
        ConstantSelectionPropertyEditorTest.assertTrue((boolean)field2.exists());
        this.setField(field2);
        this.assertEditor("public class Test extends MyPanel implements PrefConstants {", "  public Test() {", "    setStringId(ID_4);", "  }", "}");
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"ID_4", (Object)this.getText());
    }

    @Test
    public void test_setField_local() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public static final String LOCAL_ID = 'value';", "  public Test() {", "  }", "}");
        IType constantsType = m_testProject.getJavaProject().findType("test.Test");
        IField field = constantsType.getField("LOCAL_ID");
        ConstantSelectionPropertyEditorTest.assertTrue((boolean)field.exists());
        this.setField(field);
        this.assertEditor("public class Test extends MyPanel {", "  public static final String LOCAL_ID = 'value';", "  public Test() {", "    setStringId(LOCAL_ID);", "  }", "}");
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"LOCAL_ID", (Object)this.getText());
    }

    @Test
    public void test_utils_simpleName_field() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public static final String LOCAL_ID = 'value';", "  public static final String LOCAL_ID2 = 'value2';", "  private static final String LOCAL_ID3 = 'value3';", "  public static final int INT_VALUE = 0;", "  public Test() {", "    setStringId(LOCAL_ID);", "  }", "}");
        IField field = this.getField();
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"LOCAL_ID", (Object)field.getElementName());
        IType type = this.getType();
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"test.Test", (Object)type.getFullyQualifiedName());
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"LOCAL_ID", (Object)this.getText());
        List<IField> fields = this.getFields();
        Assertions.assertThat(fields).hasSize(2);
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"LOCAL_ID", (Object)fields.get(0).getElementName());
        ConstantSelectionPropertyEditorTest.assertEquals((Object)"LOCAL_ID2", (Object)fields.get(1).getElementName());
    }

    @Test
    public void test_utils_simpleName_variable() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    String id = 'value';", "    setStringId(id);", "  }", "}");
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getField());
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getType());
        ConstantSelectionPropertyEditorTest.assertNull((Object)this.getText());
    }

    @Test
    public void test_getUsedTypes() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public static final String LOCAL_ID = 'value';", "  public Test() {", "    setStringId(PrefConstants.ID_1);", "    setStringId2(LOCAL_ID);", "  }", "}");
        Set<IType> types = this.getUsedTypes();
        HashSet<String> typeNames = new HashSet<String>();
        for (IType type : types) {
            typeNames.add(type.getFullyQualifiedName());
        }
        Assertions.assertThat(typeNames).containsOnly((Object[])new String[]{"test.PrefConstants", "test.Test"});
    }

    @Test
    public void test_getLocalTypes_0() throws Exception {
        this.parseContainer("public class Test extends MyPanel implements PrefConstants {", "  public Test() {", "  }", "}");
        List<IType> types = this.getLocalTypes();
        HashSet<String> typeNames = new HashSet<String>();
        for (IType type : types) {
            typeNames.add(type.getFullyQualifiedName());
        }
        Assertions.assertThat(typeNames).containsOnly((Object[])new String[]{"test.PrefConstants"});
    }

    @Test
    public void test_getLocalTypes_1() throws Exception {
        ConstantSelectionPropertyEditorTest.setFileContentSrc("test/BadConstants.java", ConstantSelectionPropertyEditorTest.getSourceDQ("package test;", "public interface BadConstants {", "  int ID = 0;", "}"));
        ConstantSelectionPropertyEditorTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyPanel implements PrefConstants, BadConstants {", "  public static final String LOCAL_ID = 'value';", "  public Test() {", "  }", "}");
        List<IType> types = this.getLocalTypes();
        HashSet<String> typeNames = new HashSet<String>();
        for (IType type : types) {
            typeNames.add(type.getFullyQualifiedName());
        }
        Assertions.assertThat(typeNames).containsOnly((Object[])new String[]{"test.PrefConstants", "test.Test"});
    }

    @Test
    public void test_combo_items() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setStringId(PrefConstants.ID_1);", "  }", "}");
        Property property = panel.getPropertyByTitle("stringId");
        ConstantSelectionPropertyEditorTest.addComboPropertyItems(property);
        List<String> items = ConstantSelectionPropertyEditorTest.getComboPropertyItems();
        Assertions.assertThat(items).containsExactly((Object[])new String[]{"ID_1", "ID_4"});
        ConstantSelectionPropertyEditorTest.setComboPropertySelection(1);
        ConstantSelectionPropertyEditorTest.setComboPropertySelection(property);
        ConstantSelectionPropertyEditorTest.assertEquals((long)0L, (long)ConstantSelectionPropertyEditorTest.getComboPropertySelection());
        ConstantSelectionPropertyEditorTest.setComboPropertyValue(property, 1);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setStringId(PrefConstants.ID_4);", "  }", "}");
    }
}

