/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.burningwave.core.classes.AnnotationSourceGenerator;
import org.burningwave.core.classes.SourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;

public class GenericSourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = -7508101348682677540L;
    private Collection<String> outerCode;
    private Collection<AnnotationSourceGenerator> annotations;
    private TypeDeclarationSourceGenerator type;
    private String name;
    private String hirearchyOperator;
    private Collection<TypeDeclarationSourceGenerator> hirearchyElements;

    private GenericSourceGenerator(String name) {
        this.name = name;
    }

    public static GenericSourceGenerator create(String name) {
        return new GenericSourceGenerator(name);
    }

    public static GenericSourceGenerator create(Class<?> cls) {
        GenericSourceGenerator generic = new GenericSourceGenerator(cls.getSimpleName());
        generic.type = TypeDeclarationSourceGenerator.create(cls);
        return generic;
    }

    public String getName() {
        return this.name;
    }

    public GenericSourceGenerator addOuterCode(String ... codes) {
        Optional.ofNullable(this.outerCode).orElseGet(() -> {
            this.outerCode = new ArrayList<String>();
            return this.outerCode;
        });
        for (String code : codes) {
            this.outerCode.add(code);
        }
        return this;
    }

    public GenericSourceGenerator addAnnotation(AnnotationSourceGenerator ... annotations) {
        Optional.ofNullable(this.annotations).orElseGet(() -> {
            this.annotations = new ArrayList<AnnotationSourceGenerator>();
            return this.annotations;
        });
        for (AnnotationSourceGenerator annotation : annotations) {
            this.annotations.add(annotation);
        }
        return this;
    }

    public GenericSourceGenerator expands(TypeDeclarationSourceGenerator ... hirearchyElements) {
        this.hirearchyOperator = "extends";
        this.hirearchyElements = Optional.ofNullable(this.hirearchyElements).orElseGet(ArrayList::new);
        for (TypeDeclarationSourceGenerator hirearchyElement : hirearchyElements) {
            this.hirearchyElements.add(hirearchyElement);
        }
        return this;
    }

    public GenericSourceGenerator parentOf(TypeDeclarationSourceGenerator hirearchyElement) {
        this.hirearchyOperator = "super";
        this.hirearchyElements = Optional.ofNullable(this.hirearchyElements).orElseGet(ArrayList::new);
        this.hirearchyElements.add(hirearchyElement);
        return this;
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        ArrayList<TypeDeclarationSourceGenerator> types = new ArrayList<TypeDeclarationSourceGenerator>();
        Optional.ofNullable(this.annotations).ifPresent(annotations -> {
            for (AnnotationSourceGenerator annotation : annotations) {
                types.addAll(annotation.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.hirearchyElements).ifPresent(hirearchyElements -> hirearchyElements.forEach(hirearchyElement -> types.addAll(hirearchyElement.getTypeDeclarations())));
        Optional.ofNullable(this.type).ifPresent(hirearchyElement -> types.add(this.type));
        return types;
    }

    private String getAnnotations() {
        return Optional.ofNullable(this.annotations).map(annts -> this.getOrEmpty((Collection<?>)annts)).orElseGet(() -> null);
    }

    @Override
    public String make() {
        return this.getOrEmpty(this.outerCode, this.getAnnotations(), this.name, this.hirearchyOperator, this.getOrEmpty(this.hirearchyElements, " & "));
    }
}

