/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.model;

import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.model.Model;

public enum ModelType {
    Functionblock(".fbmodel", FunctionblockModel.class),
    InformationModel(".infomodel", InformationModel.class),
    Datatype(".type", Type.class),
    Mapping(".mapping", MappingModel.class);

    private String extension;
    private Class<?> modelClass;

    private ModelType(String extension, Class<?> modelClass) {
        this.extension = extension;
        this.modelClass = modelClass;
    }

    public String getExtension() {
        return this.extension;
    }

    public <M extends Model> Class<M> getModelClass() {
        return this.modelClass;
    }

    public static ModelType create(String fileName) {
        String fileEnding = fileName.substring(fileName.indexOf("."));
        if (ModelType.Functionblock.extension.equalsIgnoreCase(fileEnding)) {
            return Functionblock;
        }
        if (ModelType.InformationModel.extension.equalsIgnoreCase(fileEnding)) {
            return InformationModel;
        }
        if (ModelType.Datatype.extension.equalsIgnoreCase(fileEnding)) {
            return Datatype;
        }
        if (ModelType.Mapping.extension.equalsIgnoreCase(fileEnding)) {
            return Mapping;
        }
        throw new UnsupportedOperationException("Given filename is unknown");
    }
}

