/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class EISCompositeObjectMapping
extends AbstractCompositeObjectMapping
implements EISMapping {
    @Override
    public boolean isEISMapping() {
        return true;
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public void setFieldName(String fieldName) {
        this.setField(new DatabaseField(fieldName));
    }

    @Override
    protected Object buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord record, DatabaseMapping.WriteType writeType) {
        if (((EISDescriptor)this.getDescriptor()).isXMLFormat()) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)this.getReferenceDescriptor(attributeValue, session).getObjectBuilder();
            return objectBuilder.buildRow(attributeValue, session, this.getField(), (XMLRecord)record);
        }
        AbstractRecord nestedRow = this.getObjectBuilder(attributeValue, session).buildRow(attributeValue, session, writeType);
        return this.getReferenceDescriptor(attributeValue, session).buildFieldValueFromNestedRow(nestedRow, session);
    }

    @Override
    protected Object buildCompositeObject(ObjectBuilder objectBuilder, AbstractRecord nestedRow, ObjectBuildingQuery query, CacheKey parentCacheKey, JoinedAttributeManager joinManager, AbstractSession targetSession) {
        if (((EISDescriptor)this.getDescriptor()).isXMLFormat()) {
            return objectBuilder.buildObject(query, nestedRow, joinManager);
        }
        Object aggregateObject = objectBuilder.buildNewInstance();
        objectBuilder.buildAttributesIntoObject(aggregateObject, parentCacheKey, nestedRow, query, joinManager, false, targetSession);
        return aggregateObject;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord record, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (((EISDescriptor)this.getDescriptor()).isXMLFormat() && ((XMLField)this.getField()).isSelfField()) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)this.getReferenceDescriptor(attributeValue, session).getObjectBuilder();
            objectBuilder.buildIntoNestedRow(record, attributeValue, session);
        } else {
            Object fieldValue = null;
            if (attributeValue != null) {
                fieldValue = this.buildCompositeRow(attributeValue, session, record, writeType);
            }
            record.put(this.getField(), fieldValue);
        }
    }

    @Override
    public void preInitialize(AbstractSession session) {
        super.preInitialize(session);
        if (((EISDescriptor)this.descriptor).isXMLFormat() && !(this.field instanceof XMLField)) {
            XMLField newField = new XMLField(this.field.getName());
            this.field = newField;
        }
    }
}

