/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalAprInputBuffer;
import org.apache.coyote.http11.InternalAprOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProcessor
extends AbstractHttp11Processor<Long> {
    private static final Log log = LogFactory.getLog(Http11AprProcessor.class);
    protected InternalAprInputBuffer inputBuffer = null;
    protected InternalAprOutputBuffer outputBuffer = null;
    protected AprEndpoint.SendfileData sendfileData = null;
    protected String clientCertProvider = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11AprProcessor(int headerBufferSize, AprEndpoint endpoint, int maxTrailerSize, int maxExtensionSize) {
        super(endpoint);
        this.inputBuffer = new InternalAprInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalAprOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize, maxExtensionSize);
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.error = !this.adapter.event(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error || status == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (!this.endpoint.isPaused()) {
            return true;
        }
        this.response.setStatus(503);
        this.adapter.log(this.request, this.response, 0L);
        this.error = true;
        return false;
    }

    @Override
    protected void setSocketTimeout(int timeout) {
        Socket.timeoutSet((Long)this.socketWrapper.getSocket(), timeout * 1000);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Long> socketWrapper) {
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Long> socketWrapper) {
        this.openSocket = this.keepAlive;
        if (this.sendfileData != null && !this.error) {
            this.sendfileData.socket = socketWrapper.getSocket();
            this.sendfileData.keepAlive = this.keepAlive;
            if (!((AprEndpoint)this.endpoint).getSendfile().add(this.sendfileData)) {
                if (this.sendfileData.socket == 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.sendfile.error"));
                    }
                    this.error = true;
                } else {
                    this.sendfileInProgress = true;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    public void recycleInternal() {
        this.socketWrapper = null;
        this.sendfileData = null;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        long socketRef = (Long)this.socketWrapper.getSocket();
        if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            if (this.remoteAddr == null && socketRef != 0L) {
                try {
                    long sa = Address.get(1, socketRef);
                    this.remoteAddr = Address.getip(sa);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.remoteAddr().setString(this.remoteAddr);
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            if (this.localName == null && socketRef != 0L) {
                try {
                    long sa = Address.get(0, socketRef);
                    this.localName = Address.getnameinfo(sa, 0);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.localName().setString(this.localName);
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.remoteHost == null && socketRef != 0L) {
                try {
                    long sa = Address.get(1, socketRef);
                    this.remoteHost = Address.getnameinfo(sa, 0);
                    if (this.remoteHost == null) {
                        this.remoteHost = Address.getip(sa);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.remoteHost().setString(this.remoteHost);
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.localAddr == null && socketRef != 0L) {
                try {
                    long sa = Address.get(0, socketRef);
                    this.localAddr = Address.getip(sa);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.localAddr().setString(this.localAddr);
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.remotePort == -1 && socketRef != 0L) {
                try {
                    long sa = Address.get(1, socketRef);
                    Sockaddr addr = Address.getInfo(sa);
                    this.remotePort = addr.port;
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.setRemotePort(this.remotePort);
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.localPort == -1 && socketRef != 0L) {
                try {
                    long sa = Address.get(0, socketRef);
                    Sockaddr addr = Address.getInfo(sa);
                    this.localPort = addr.port;
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.setLocalPort(this.localPort);
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            if (this.endpoint.isSSLEnabled() && socketRef != 0L) {
                try {
                    Object sslO = SSLSocket.getInfoS(socketRef, 2);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    int certLength = SSLSocket.getInfoI(socketRef, 1024);
                    byte[] clientCert = SSLSocket.getInfoB(socketRef, 263);
                    X509Certificate[] certs = null;
                    if (clientCert != null && certLength > -1) {
                        certs = new X509Certificate[certLength + 1];
                        CertificateFactory cf = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                        certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                        for (int i = 0; i < certLength; ++i) {
                            byte[] data = SSLSocket.getInfoB(socketRef, 1024 + i);
                            certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                        }
                    }
                    if (certs != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                    }
                    sslO = SSLSocket.getInfoI(socketRef, 3);
                    this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    sslO = SSLSocket.getInfoS(socketRef, 1);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.endpoint.isSSLEnabled() && socketRef != 0L) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                try {
                    SSLSocket.setVerify(socketRef, 2, ((AprEndpoint)this.endpoint).getSSLVerifyDepth());
                    if (SSLSocket.renegotiate(socketRef) == 0) {
                        int certLength = SSLSocket.getInfoI(socketRef, 1024);
                        byte[] clientCert = SSLSocket.getInfoB(socketRef, 263);
                        X509Certificate[] certs = null;
                        if (clientCert != null && certLength > -1) {
                            certs = new X509Certificate[certLength + 1];
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                            for (int i = 0; i < certLength; ++i) {
                                byte[] data = SSLSocket.getInfoB(socketRef, 1024 + i);
                                certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                            }
                        }
                        if (certs != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                        }
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.AVAILABLE) {
            this.request.setAvailable(this.inputBuffer.available());
        } else if (actionCode == ActionCode.COMET_BEGIN) {
            this.comet = true;
        } else if (actionCode == ActionCode.COMET_END) {
            this.comet = false;
        } else if (actionCode == ActionCode.COMET_CLOSE) {
            ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
        } else if (actionCode != ActionCode.COMET_SETTIMEOUT) {
            if (actionCode == ActionCode.ASYNC_COMPLETE) {
                if (this.asyncStateMachine.asyncComplete()) {
                    ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                }
            } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
                if (param == null) {
                    return;
                }
                long timeout = (Long)param;
                this.socketWrapper.setTimeout(timeout);
            } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new AprEndpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.start = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.end = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            return true;
        }
        return false;
    }

    @Override
    protected AbstractInputBuffer<Long> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Long> getOutputBuffer() {
        return this.outputBuffer;
    }
}

