/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.equinox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.math.Sets;

public final class UsesAnalyser {
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public AnalysedUsesConflict[] getUsesConflicts(State state, ResolverError usesError) {
        VersionConstraint constraint = usesError.getUnsatisfiedConstraint();
        ArrayList<AnalysedUsesConflict> analysedUsesConflicts = new ArrayList<AnalysedUsesConflict>();
        if (constraint instanceof ImportPackageSpecification) {
            Map<String, Set<SourcedPackage>> usedPackages;
            ExportPackageDescription exportPackage;
            ImportPackageSpecification rootImport = (ImportPackageSpecification)constraint;
            Map<String, Set<SourcedPackage>> directPackages = this.generateExportPackagesVisibleInFailedBundle(state, rootImport);
            ExportPackageDescription[] exportPackageDescriptionArray = this.getResolvedCandidateExports(state, rootImport);
            int n = exportPackageDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                exportPackage = exportPackageDescriptionArray[n2];
                usedPackages = this.generateExportPackagesUsedViaExportPackage(state, exportPackage);
                analysedUsesConflicts.addAll(this.findConflictingExports(usedPackages, directPackages));
                ++n2;
            }
            if (analysedUsesConflicts.isEmpty()) {
                exportPackageDescriptionArray = this.getUnresolvedCandidateExports(state, rootImport);
                n = exportPackageDescriptionArray.length;
                n2 = 0;
                while (n2 < n) {
                    exportPackage = exportPackageDescriptionArray[n2];
                    usedPackages = this.generateExportPackagesUsedViaExportPackage(state, exportPackage);
                    analysedUsesConflicts.addAll(this.findConflictingExports(usedPackages, directPackages));
                    ++n2;
                }
            }
        }
        return analysedUsesConflicts.toArray(new AnalysedUsesConflict[analysedUsesConflicts.size()]);
    }

    public ResolverError[] getUsesResolverErrors(State state, BundleDescription bundle) {
        ResolverError[] errors = state.getResolverErrors(bundle);
        if (errors != null) {
            ArrayList<ResolverError> usesErrors = new ArrayList<ResolverError>(errors.length);
            ResolverError[] resolverErrorArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverError re = resolverErrorArray[n2];
                if (re.getType() == 32) {
                    usesErrors.add(re);
                }
                ++n2;
            }
            return usesErrors.toArray(new ResolverError[usesErrors.size()]);
        }
        return null;
    }

    private List<AnalysedUsesConflict> findConflictingExports(Map<String, Set<SourcedPackage>> usedPackages, Map<String, Set<SourcedPackage>> directPackages) {
        ArrayList<AnalysedUsesConflict> usesConflicts = new ArrayList<AnalysedUsesConflict>();
        Set packagesInCommon = Sets.intersection(usedPackages.keySet(), directPackages.keySet());
        for (String packageName : packagesInCommon) {
            Set<SourcedPackage> allUsed = usedPackages.get(packageName);
            Set<SourcedPackage> allWired = directPackages.get(packageName);
            for (SourcedPackage sourcedPackage : allUsed) {
                UsedBySourcedPackage usedSourced = (UsedBySourcedPackage)sourcedPackage;
                if (UsesAnalyser.exportDescriptionOccursIn(usedSourced.getSource(), allWired)) continue;
                for (SourcedPackage sp : allWired) {
                    usesConflicts.add(new AnalysedUsesConflict(usedSourced, sp));
                }
            }
        }
        return usesConflicts;
    }

    private static final boolean exportDescriptionOccursIn(ExportPackageDescription source, Set<SourcedPackage> allWired) {
        for (SourcedPackage w : allWired) {
            if (!w.getSource().equals(source)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Set<SourcedPackage>> generateExportPackagesUsedViaExportPackage(State state, ExportPackageDescription exportPackage) {
        HashMap<String, Set<SourcedPackage>> usedPackages = new HashMap<String, Set<SourcedPackage>>();
        HashSet<String> knownPackages = new HashSet<String>();
        this.addUsedImportedPackages(state, usedPackages, exportPackage, exportPackage, knownPackages);
        return usedPackages;
    }

    private Map<String, Set<SourcedPackage>> generateExportPackagesVisibleInFailedBundle(State state, ImportPackageSpecification rootImport) {
        BundleDescription failedBundle = rootImport.getBundle();
        Map<String, Set<SourcedPackage>> directPackages = this.getOtherImportedPackages(state, rootImport);
        HashMap<String, Set<SourcedPackage>> additionalPackages = new HashMap<String, Set<SourcedPackage>>();
        Set<Map.Entry<String, Set<SourcedPackage>>> keys = directPackages.entrySet();
        HashSet<String> knownPackages = new HashSet<String>();
        for (Map.Entry<String, Set<SourcedPackage>> key : keys) {
            for (SourcedPackage sp : key.getValue()) {
                ExportPackageDescription source = sp.getSource();
                this.addUsedImportedPackages(state, additionalPackages, source, source, knownPackages);
            }
        }
        directPackages.putAll(additionalPackages);
        directPackages.putAll(this.getExportedPackages(failedBundle));
        return directPackages;
    }

    private ExportPackageDescription[] getResolvedCandidateExports(State state, ImportPackageSpecification rootImport) {
        ArrayList<ExportPackageDescription> exports = new ArrayList<ExportPackageDescription>();
        BundleDescription[] bundles = state.getResolvedBundles();
        if (bundles != null) {
            BundleDescription[] bundleDescriptionArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundle = bundleDescriptionArray[n2];
                ExportPackageDescription[] exportPackageDescriptionArray = bundle.getExportPackages();
                int n3 = exportPackageDescriptionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportPackage = exportPackageDescriptionArray[n4];
                    if (rootImport.isSatisfiedBy((BaseDescription)exportPackage)) {
                        exports.add(exportPackage);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return exports.toArray(new ExportPackageDescription[exports.size()]);
    }

    private ExportPackageDescription[] getUnresolvedCandidateExports(State state, ImportPackageSpecification rootImport) {
        ArrayList<ExportPackageDescription> exports = new ArrayList<ExportPackageDescription>();
        BundleDescription[] resolvedBundles = state.getResolvedBundles();
        BundleDescription[] bundles = state.getBundles();
        if (bundles != null) {
            BundleDescription[] bundleDescriptionArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundle = bundleDescriptionArray[n2];
                if (UsesAnalyser.notInArray(bundle, resolvedBundles)) {
                    ExportPackageDescription[] exportPackageDescriptionArray = bundle.getExportPackages();
                    int n3 = exportPackageDescriptionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExportPackageDescription exportPackage = exportPackageDescriptionArray[n4];
                        if (rootImport.isSatisfiedBy((BaseDescription)exportPackage)) {
                            exports.add(exportPackage);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return exports.toArray(new ExportPackageDescription[exports.size()]);
    }

    private static final boolean notInArray(BundleDescription bundle, BundleDescription[] resolvedBundles) {
        if (resolvedBundles == null) {
            return true;
        }
        BundleDescription[] bundleDescriptionArray = resolvedBundles;
        int n = resolvedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription b = bundleDescriptionArray[n2];
            if (b == bundle) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void addUsedImportedPackages(State state, Map<String, Set<SourcedPackage>> packages, ExportPackageDescription exportPackage, ExportPackageDescription topDependency, Set<String> knownPackages) {
        String[] packageNames = (String[])exportPackage.getDirective("uses");
        if (packageNames != null) {
            BundleDescription bundle = exportPackage.getExporter();
            ExportPackageDescription[] allExports = bundle.getExportPackages();
            ImportPackageSpecification[] allImports = bundle.getImportPackages();
            ExportPackageDescription[] allResolvedImports = bundle.getResolvedImports();
            String[] stringArray = packageNames;
            int n = packageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                ExportPackageDescription localExport = UsesAnalyser.findExportPackageDescriptionInArray(allExports, packageName);
                if (localExport != null) {
                    UsesAnalyser.addSourcedPackageToMapSet(packages, packageName, new UsedBySourcedPackage(topDependency, localExport));
                }
                if (!knownPackages.contains(packageName)) {
                    ExportPackageDescription localResolvedImport = UsesAnalyser.findExportPackageDescriptionInArray(allResolvedImports, packageName);
                    if (localResolvedImport != null) {
                        knownPackages.add(packageName);
                        UsesAnalyser.addSourcedPackageToMapSet(packages, packageName, new UsedBySourcedPackage(topDependency, localResolvedImport));
                        this.addUsedImportedPackages(state, packages, localResolvedImport, topDependency, knownPackages);
                    } else {
                        ExportPackageDescription[] matchingExports;
                        ImportPackageSpecification anImport = UsesAnalyser.findImportPackageSpecificationInArray(allImports, packageName);
                        if (anImport != null && (matchingExports = this.getCandidateExports(state, anImport)).length != 0) {
                            knownPackages.add(packageName);
                            ExportPackageDescription[] exportPackageDescriptionArray = matchingExports;
                            int n3 = matchingExports.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ExportPackageDescription matchingExport = exportPackageDescriptionArray[n4];
                                UsesAnalyser.addSourcedPackageToMapSet(packages, packageName, new UsedBySourcedPackage(topDependency, matchingExport));
                                this.addUsedImportedPackages(state, packages, matchingExport, topDependency, knownPackages);
                                ++n4;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static final ImportPackageSpecification findImportPackageSpecificationInArray(ImportPackageSpecification[] allImports, String packageName) {
        ImportPackageSpecification[] importPackageSpecificationArray = allImports;
        int n = allImports.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification ips = importPackageSpecificationArray[n2];
            if (packageName.equals(ips.getName())) {
                return ips;
            }
            ++n2;
        }
        return null;
    }

    private static final void addSourcedPackageToMapSet(Map<String, Set<SourcedPackage>> packages, String packageName, SourcedPackage sourcedPackage) {
        Set<SourcedPackage> sourcedSet = packages.get(packageName);
        if (sourcedSet == null) {
            sourcedSet = new HashSet<SourcedPackage>();
        }
        sourcedSet.add(sourcedPackage);
        packages.put(packageName, sourcedSet);
    }

    private static final ExportPackageDescription findExportPackageDescriptionInArray(ExportPackageDescription[] allExports, String packageName) {
        ExportPackageDescription[] exportPackageDescriptionArray = allExports;
        int n = allExports.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription epd = exportPackageDescriptionArray[n2];
            if (packageName.equals(epd.getName())) {
                return epd;
            }
            ++n2;
        }
        return null;
    }

    private Map<String, Set<SourcedPackage>> getOtherImportedPackages(State state, ImportPackageSpecification rootImport) {
        ImportPackageSpecification[] importSpecifications;
        BundleDescription bundle = rootImport.getBundle();
        HashMap<String, Set<SourcedPackage>> packages = new HashMap<String, Set<SourcedPackage>>();
        ImportPackageSpecification[] importPackageSpecificationArray = importSpecifications = bundle.getImportPackages();
        int n = importSpecifications.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importSpecification = importPackageSpecificationArray[n2];
            if (rootImport != importSpecification && !"optional".equals(importSpecification.getDirective("resolution"))) {
                ExportPackageDescription[] exportPackages;
                ExportPackageDescription[] exportPackageDescriptionArray = exportPackages = this.getCandidateExports(state, importSpecification);
                int n3 = exportPackages.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportPackage = exportPackageDescriptionArray[n4];
                    UsesAnalyser.addSourcedPackageToMapSet(packages, exportPackage.getName(), new ImportedSourcedPackage(rootImport, exportPackage));
                    ++n4;
                }
            }
            ++n2;
        }
        return packages;
    }

    private ExportPackageDescription[] getCandidateExports(State state, ImportPackageSpecification importSpecification) {
        ExportPackageDescription[] pkgs = this.getResolvedCandidateExports(state, importSpecification);
        if (pkgs.length == 0) {
            pkgs = this.getUnresolvedCandidateExports(state, importSpecification);
        }
        return pkgs;
    }

    private Map<String, Set<SourcedPackage>> getExportedPackages(BundleDescription bundle) {
        ExportPackageDescription[] packageArray = bundle.getExportPackages();
        HashMap<String, Set<SourcedPackage>> packages = new HashMap<String, Set<SourcedPackage>>();
        if (packageArray != null) {
            ExportPackageDescription[] exportPackageDescriptionArray = packageArray;
            int n = packageArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription exportPackage = exportPackageDescriptionArray[n2];
                UsesAnalyser.addSourcedPackageToMapSet(packages, exportPackage.getName(), new SourcedPackage(exportPackage));
                ++n2;
            }
        }
        return packages;
    }

    private static final String stringOf(ExportPackageDescription source) {
        BundleDescription bundle = source.getSupplier();
        StringBuilder sb = new StringBuilder("'");
        sb.append(source.getName()).append("_").append(source.getVersion()).append("' in bundle ").append(UsesAnalyser.stringOf(bundle));
        return sb.toString();
    }

    private static final String stringOf(BundleDescription bundle) {
        StringBuilder sb = new StringBuilder("'");
        sb.append(bundle.getSymbolicName()).append("_").append(bundle.getVersion()).append("[").append(bundle.getBundleId()).append("]").append("'");
        return sb.toString();
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.UsesAnalyser");
    }

    public static final class AnalysedUsesConflict {
        private final UsedBySourcedPackage usedPackage;
        private final SourcedPackage resolvedPackage;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        private AnalysedUsesConflict(UsedBySourcedPackage used, SourcedPackage resolved) {
            this.usedPackage = used;
            this.resolvedPackage = resolved;
        }

        public String[] getConflictStatement() {
            return new String[]{"package        " + this.usedPackage.toString(), "conflicts with " + this.resolvedPackage.toString()};
        }

        public ExportPackageDescription getConflictingPackage() {
            return this.usedPackage == null ? null : this.usedPackage.getSource();
        }

        public ExportPackageDescription getUsesRootPackage() {
            return this.usedPackage == null ? null : this.usedPackage.getUsedBy();
        }

        public ExportPackageDescription getPackage() {
            return this.resolvedPackage == null ? null : this.resolvedPackage.getSource();
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.UsesAnalyser$AnalysedUsesConflict");
        }
    }

    public static final class CollisionReason
    extends Enum<CollisionReason> {
        public static final /* enum */ CollisionReason DISJOINT_VERSION_RANGES;
        public static final /* enum */ CollisionReason ATTRIBUTE_MISMATCH;
        private static final /* synthetic */ CollisionReason[] ENUM$VALUES;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.UsesAnalyser$CollisionReason");
            DISJOINT_VERSION_RANGES = new CollisionReason();
            ATTRIBUTE_MISMATCH = new CollisionReason();
            ENUM$VALUES = new CollisionReason[]{DISJOINT_VERSION_RANGES, ATTRIBUTE_MISMATCH};
        }

        public static CollisionReason[] values() {
            CollisionReason[] collisionReasonArray = ENUM$VALUES;
            int n = collisionReasonArray.length;
            CollisionReason[] collisionReasonArray2 = new CollisionReason[n];
            System.arraycopy(ENUM$VALUES, 0, collisionReasonArray2, 0, n);
            return collisionReasonArray2;
        }

        public static CollisionReason valueOf(String string) {
            return Enum.valueOf(CollisionReason.class, string);
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }
    }

    public static interface DependentConstraintCollision {
        public ImportPackageSpecification getConsumerConstraint();

        public ImportPackageSpecification getSupplierConstraint();

        public CollisionReason getCollisionReason();
    }

    private static final class ImportedSourcedPackage
    extends SourcedPackage {
        private final ImportPackageSpecification rootImport;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public ImportedSourcedPackage(ImportPackageSpecification rootImport, ExportPackageDescription source) {
            super(source);
            this.rootImport = rootImport;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(" imported by bundle ").append(UsesAnalyser.stringOf(this.rootImport.getBundle()));
            return sb.toString();
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.UsesAnalyser$ImportedSourcedPackage");
        }
    }

    public static interface PossibleMatch {
        public ExportPackageDescription getSupplier();

        public boolean isDependentConstraintMismatch();

        public DependentConstraintCollision[] getCollisions();
    }

    private static class SourcedPackage {
        private final ExportPackageDescription source;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public SourcedPackage(ExportPackageDescription source) {
            this.source = source;
        }

        public String toString() {
            return UsesAnalyser.stringOf(this.source);
        }

        public ExportPackageDescription getSource() {
            return this.source;
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.UsesAnalyser$SourcedPackage");
        }
    }

    private static final class UsedBySourcedPackage
    extends SourcedPackage {
        private final ExportPackageDescription usedBy;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public UsedBySourcedPackage(ExportPackageDescription usedBy, ExportPackageDescription source) {
            super(source);
            this.usedBy = usedBy;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(" used by ").append(UsesAnalyser.stringOf(this.usedBy));
            return sb.toString();
        }

        public ExportPackageDescription getUsedBy() {
            return this.usedBy;
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.UsesAnalyser$UsedBySourcedPackage");
        }
    }

    public static interface UsesViolation {
        public VersionConstraint getConstraint();

        public PossibleMatch[] getPossibleMatches();
    }
}

