/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionUsageException;

public abstract class AbstractTransactionStatus
implements TransactionStatus {
    private boolean rollbackOnly = false;
    private boolean completed = false;
    private Object savepoint;

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.isLocalRollbackOnly() || this.isGlobalRollbackOnly();
    }

    public boolean isLocalRollbackOnly() {
        return this.rollbackOnly;
    }

    public boolean isGlobalRollbackOnly() {
        return false;
    }

    public void flush() {
    }

    public void setCompleted() {
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    protected void setSavepoint(Object savepoint) {
        this.savepoint = savepoint;
    }

    protected Object getSavepoint() {
        return this.savepoint;
    }

    public boolean hasSavepoint() {
        return this.savepoint != null;
    }

    public void createAndHoldSavepoint() throws TransactionException {
        this.setSavepoint(this.getSavepointManager().createSavepoint());
    }

    public void rollbackToHeldSavepoint() throws TransactionException {
        if (!this.hasSavepoint()) {
            throw new TransactionUsageException("No savepoint associated with current transaction");
        }
        this.getSavepointManager().rollbackToSavepoint(this.getSavepoint());
        this.setSavepoint(null);
    }

    public void releaseHeldSavepoint() throws TransactionException {
        if (!this.hasSavepoint()) {
            throw new TransactionUsageException("No savepoint associated with current transaction");
        }
        this.getSavepointManager().releaseSavepoint(this.getSavepoint());
        this.setSavepoint(null);
    }

    public Object createSavepoint() throws TransactionException {
        return this.getSavepointManager().createSavepoint();
    }

    public void rollbackToSavepoint(Object savepoint) throws TransactionException {
        this.getSavepointManager().rollbackToSavepoint(savepoint);
    }

    public void releaseSavepoint(Object savepoint) throws TransactionException {
        this.getSavepointManager().releaseSavepoint(savepoint);
    }

    protected SavepointManager getSavepointManager() {
        throw new NestedTransactionNotSupportedException("This transaction does not support savepoints");
    }
}

