/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.zest.sources;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.shape.Polygon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.addon.viewers.runtime.sources.QueryLabelProvider;
import org.eclipse.viatra.addon.viewers.runtime.util.FormatParser;
import org.eclipse.viatra.integration.zest.viewer.IGraphAttributesProvider2;

public class ZestLabelProvider
extends QueryLabelProvider
implements IColorProvider,
IGraphAttributesProvider2 {
    private Map<RGB, Color> colorMap = Maps.newHashMap();

    public ZestLabelProvider(ViewerState state, Display display) {
        super(state, display);
    }

    private Color getColorProperty(FormattableElement element, String property) {
        RGB color;
        if (FormatParser.isFormatted((FormattableElement)element) && (color = FormatParser.getColorFormatProperty((FormattableElement)element, (String)property)) != null) {
            return this.getColor(color);
        }
        return null;
    }

    private Color getColor(RGB rgb) {
        if (!this.colorMap.containsKey(rgb)) {
            Color newColor = new Color((Device)this.display, rgb);
            this.colorMap.put(rgb, newColor);
            return newColor;
        }
        return this.colorMap.get(rgb);
    }

    public Color getBackground(Object entity) {
        if (entity instanceof Item) {
            return this.getColorProperty((FormattableElement)entity, "org.eclipse.viatra.viewers.format.color");
        }
        return null;
    }

    public Color getForeground(Object entity) {
        if (entity instanceof Item) {
            return this.getColorProperty((FormattableElement)entity, "org.eclipse.viatra.viewers.format.textcolor");
        }
        return null;
    }

    public void dispose() {
        for (Map.Entry<RGB, Color> colorEntry : this.colorMap.entrySet()) {
            Color color = colorEntry.getValue();
            if (color == null || color.isDisposed()) continue;
            color.dispose();
        }
        super.dispose();
    }

    public Map<String, Object> getEdgeAttributes(Object sourceNode, Object targetNode) {
        HashMap attributes = Maps.newHashMap();
        attributes.put("edge-target-decoration", new DiamondHead());
        return attributes;
    }

    public Map<String, Object> getEdgeAttributes(Object edge) {
        HashMap attributes = Maps.newHashMap();
        attributes.put("edge-target-decoration", new DiamondHead());
        return attributes;
    }

    public Map<String, Object> getGraphAttributes() {
        return Maps.newHashMap();
    }

    public Map<String, Object> getNestedGraphAttributes(Object nestingNode) {
        return Maps.newHashMap();
    }

    public Map<String, Object> getNodeAttributes(Object node) {
        return Maps.newHashMap();
    }

    static class DiamondHead
    extends Polygon {
        public DiamondHead() {
            super(new double[]{-15.0, 0.0, -7.5, -3.75, -7.5, 3.75, -15.0, 0.0});
        }
    }
}

