/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.zest.sources;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.IViewerStateListener;
import org.eclipse.viatra.addon.viewers.runtime.notation.Containment;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.integration.zest.viewer.IGraphEdgeContentProvider;
import org.eclipse.viatra.integration.zest.viewer.ModifiableZestContentViewer;

public class ZestContentProvider
extends AbstractViewerStateListener
implements IGraphEdgeContentProvider {
    protected ModifiableZestContentViewer viewer;
    protected ViewerState state;
    protected boolean displayContainment;

    public ZestContentProvider() {
        this(false);
    }

    public ZestContentProvider(boolean displayContainment) {
        this.displayContainment = displayContainment;
    }

    public Object[] getNodes() {
        if (this.state != null) {
            Collection items = this.state.getItems();
            return items.toArray(new Item[items.size()]);
        }
        return new Object[0];
    }

    public Object[] getNestedGraphNodes(Object node) {
        return new Object[0];
    }

    public boolean hasNestedGraph(Object node) {
        return false;
    }

    public Object[] getEdges() {
        if (this.state != null) {
            Collection items = this.state.getEdges();
            return items.toArray(new Edge[items.size()]);
        }
        return new Object[0];
    }

    public Object getSource(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getSource();
        }
        return null;
    }

    public Object getTarget(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getTarget();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof ModifiableZestContentViewer));
        this.viewer = (ModifiableZestContentViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener((IViewerStateListener)this);
        }
        if (newInput == null) {
            this.state = null;
        } else if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            if (this.state.isDisposed()) {
                this.state = null;
            } else {
                this.state.addStateListener((IViewerStateListener)this);
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid input type %s for Zest Viewer.", newInput.getClass().getName()));
        }
    }

    public void itemAppeared(Item item) {
        this.viewer.addNode((Object)item);
    }

    public void itemDisappeared(Item item) {
        this.viewer.removeNode((Object)item);
    }

    public void edgeAppeared(Edge edge) {
        this.viewer.addEdge((Object)edge);
    }

    public void edgeDisappeared(Edge edge) {
        this.viewer.removeEdge((Object)edge);
    }

    public void containmentAppeared(Containment containment) {
        if (this.displayContainment) {
            this.edgeAppeared((Edge)containment);
        }
    }

    public void containmentDisappeared(Containment containment) {
        if (this.displayContainment) {
            this.edgeDisappeared((Edge)containment);
        }
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener((IViewerStateListener)this);
        }
    }
}

