/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.transformationview;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.ITransformationRegistryListener;
import org.eclipse.viatra.examples.cps.application.ui.transformationview.util.TransformationConnector;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.TransformationType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class TransformationRegistry {
    @Accessors
    private TransformationType newTransformationType = TransformationType.BATCH_VIATRA_TRANSFORMATION;
    private Map<IEditorPart, TransformationConnector> transformationMap = new HashMap<IEditorPart, TransformationConnector>();
    private final Set<ITransformationRegistryListener> listeners = new HashSet<ITransformationRegistryListener>();

    protected TransformationRegistry() {
    }

    public void setNewTransformationType(final TransformationType newTransformationType) {
        this.newTransformationType = newTransformationType;
        Procedures.Procedure1<ITransformationRegistryListener> _function = new Procedures.Procedure1<ITransformationRegistryListener>(){

            public void apply(ITransformationRegistryListener it) {
                it.transformationTypeChanged(newTransformationType);
            }
        };
        IterableExtensions.forEach(this.listeners, (Procedures.Procedure1)_function);
    }

    public static TransformationRegistry getInstance() {
        return LazyHolder.INSTANCE;
    }

    public TransformationConnector get(IEditorPart part) {
        return this.transformationMap.get(part);
    }

    public boolean containsKey(IEditorPart part) {
        return this.transformationMap.containsKey(part);
    }

    public void put(IEditorPart part, final TransformationConnector connector) {
        this.transformationMap.put(part, connector);
        Procedures.Procedure1<ITransformationRegistryListener> _function = new Procedures.Procedure1<ITransformationRegistryListener>(){

            public void apply(ITransformationRegistryListener it) {
                it.transformationAdded(connector);
            }
        };
        IterableExtensions.forEach(this.listeners, (Procedures.Procedure1)_function);
    }

    public void remove(IEditorPart part) {
        final TransformationConnector removed = this.transformationMap.remove(part);
        Procedures.Procedure1<ITransformationRegistryListener> _function = new Procedures.Procedure1<ITransformationRegistryListener>(){

            public void apply(ITransformationRegistryListener it) {
                it.transformationRemoved(removed);
            }
        };
        IterableExtensions.forEach(this.listeners, (Procedures.Procedure1)_function);
    }

    public boolean addListener(final ITransformationRegistryListener listener, boolean notifyForCurrentElements) {
        boolean added = this.listeners.add(listener);
        if (notifyForCurrentElements) {
            Procedures.Procedure1<TransformationConnector> _function = new Procedures.Procedure1<TransformationConnector>(){

                public void apply(TransformationConnector it) {
                    listener.transformationAdded(it);
                }
            };
            IterableExtensions.forEach(this.transformationMap.values(), (Procedures.Procedure1)_function);
            listener.transformationTypeChanged(this.newTransformationType);
        }
        return added;
    }

    public boolean removeListener(ITransformationRegistryListener listener) {
        return this.listeners.remove(listener);
    }

    @Pure
    public TransformationType getNewTransformationType() {
        return this.newTransformationType;
    }

    private static class LazyHolder {
        private static final TransformationRegistry INSTANCE = new TransformationRegistry();

        private LazyHolder() {
        }
    }
}

