/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.IndexerBasedConstraintCostFunction;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class HybridMatcherConstraintCostFunction
extends IndexerBasedConstraintCostFunction {
    @Override
    protected double _calculateCost(PositivePatternCall patternCall, IConstraintEvaluationContext input) throws QueryProcessingException {
        Tuple variables = patternCall.getVariablesTuple();
        Set variablesSet = variables.getDistinctElements();
        final HashMap<PVariable, Object> constantMap = new HashMap<PVariable, Object>();
        for (PConstraint _constraint : patternCall.getPSystem().getConstraints()) {
            ConstantValue constraint;
            PVariable variable;
            if (!(_constraint instanceof ConstantValue) || !variablesSet.contains(variable = (PVariable)(constraint = (ConstantValue)_constraint).getVariablesTuple().get(0)) || !input.getBoundVariables().contains(variable)) continue;
            constantMap.put(variable, constraint.getSupplierKey());
        }
        Object[] filter = new Object[variables.getSize()];
        int i = 0;
        while (i < variables.getSize()) {
            filter[i] = constantMap.get(variables.get(i));
            ++i;
        }
        Map variableIndices = variables.invertIndex();
        Iterable aggregateKeys = Iterables.transform((Iterable)Iterables.filter(input.getBoundVariables(), (Predicate)new Predicate<PVariable>(){

            public boolean apply(PVariable input) {
                return !constantMap.containsKey(input);
            }
        }), (Function)Functions.forMap((Map)variableIndices));
        IQueryResultProvider resultProvider = input.resultProviderAccess().getResultProvider(patternCall.getReferredQuery(), null);
        HashMap<Tuple, Integer> aggregatedCounts = new HashMap<Tuple, Integer>();
        Collection matches = resultProvider.getAllMatches(filter);
        int result = 0;
        for (Tuple match : matches) {
            Tuple extracted = this.extract(match, aggregateKeys);
            int count = aggregatedCounts.containsKey(extracted) ? (Integer)aggregatedCounts.get(extracted) + 1 : 1;
            aggregatedCounts.put(extracted, count);
            if (result >= count) continue;
            result = count;
        }
        return result;
    }

    private Tuple extract(Tuple tuple, Iterable<Integer> indices) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Integer index : indices) {
            list.add(tuple.get(index.intValue()));
        }
        return Tuples.flatTupleOf((Object[])list.toArray());
    }
}

