/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class IterateOverEStructuralFeatureInstances
implements IIteratingSearchOperation {
    private final EStructuralFeature feature;
    private final int sourcePosition;
    private final int targetPosition;
    private final EStructuralFeatureInstancesKey type;
    private Iterator<Tuple> it;

    public IterateOverEStructuralFeatureInstances(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
        this.type = new EStructuralFeatureInstancesKey(feature);
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void onBacktrack(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        frame.setValue(this.sourcePosition, null);
        frame.setValue(this.targetPosition, null);
        this.it = null;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Iterable tuples = context.getRuntimeContext().enumerateTuples((IInputKey)this.type, null);
        this.it = tuples.iterator();
    }

    @Override
    public boolean execute(MatchingFrame frame, ISearchContext context) {
        if (this.it.hasNext()) {
            Tuple next = this.it.next();
            frame.setValue(this.sourcePosition, next.get(0));
            frame.setValue(this.targetPosition, next.get(1));
            return true;
        }
        return false;
    }

    public String toString() {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + this.sourcePosition + ", -" + this.targetPosition + ") indexed";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.sourcePosition, (Object)this.targetPosition, (Object[])new Integer[0]);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }
}

