/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;

public class IterateOverEDatatypeInstances
extends ExtendOperation<Object>
implements IIteratingSearchOperation {
    private final EDataType dataType;
    private final EDataTypeInSlotsKey type;

    public IterateOverEDatatypeInstances(int position, EDataType dataType) {
        super(position);
        this.dataType = dataType;
        this.type = new EDataTypeInSlotsKey(dataType);
    }

    public EDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Iterable values = context.getRuntimeContext().enumerateValues((IInputKey)this.type, null);
        this.it = values.iterator();
    }

    public String toString() {
        return "extend    " + this.dataType.getName() + "(-" + this.position + ") indexed";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.position, (Object[])new Integer[0]);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }
}

