/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher.integration;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.AbstractLocalSearchResultProvider;
import org.eclipse.viatra.query.runtime.localsearch.plan.CachingPlanProvider;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.util.ICache;
import org.eclipse.viatra.query.runtime.matchers.util.PurgableCache;

public abstract class LocalSearchBackend
implements IQueryBackend {
    IQueryBackendContext context;
    IPlanProvider planProvider;
    private final Set<ILocalSearchAdapter> adapters = Sets.newHashSet();
    @Deprecated
    private final Table<EDataType, EClass, Set<EAttribute>> eAttributesByTypeForEClass = HashBasedTable.create();
    private final PurgableCache generalCache;
    private final Multimap<PQuery, AbstractLocalSearchResultProvider> resultProviderCache = ArrayListMultimap.create();

    public LocalSearchBackend(IQueryBackendContext context) {
        this.context = context;
        this.generalCache = new PurgableCache();
        this.planProvider = new CachingPlanProvider(context.getLogger());
    }

    public void flushUpdates() {
    }

    public IQueryResultProvider getResultProvider(PQuery query) throws QueryProcessingException {
        return this.getResultProvider(query, null);
    }

    public IQueryResultProvider getResultProvider(PQuery query, QueryEvaluationHint hints) throws QueryProcessingException {
        IMatcherCapability requestedCapability = this.getHintProvider().getQueryEvaluationHint(query).overrideBy(hints).calculateRequiredCapability(query);
        for (AbstractLocalSearchResultProvider existingResultProvider : this.resultProviderCache.get((Object)query)) {
            if (!requestedCapability.canBeSubstitute(existingResultProvider.getCapabilites())) continue;
            return existingResultProvider;
        }
        AbstractLocalSearchResultProvider resultProvider = this.initializeResultProvider(query, hints);
        this.resultProviderCache.put((Object)query, (Object)resultProvider);
        resultProvider.prepare();
        return resultProvider;
    }

    protected abstract AbstractLocalSearchResultProvider initializeResultProvider(PQuery var1, QueryEvaluationHint var2) throws QueryProcessingException;

    public void dispose() {
        this.eAttributesByTypeForEClass.clear();
        this.resultProviderCache.clear();
        this.generalCache.purge();
    }

    public boolean isCaching() {
        return false;
    }

    public IQueryResultProvider peekExistingResultProvider(PQuery query) {
        return null;
    }

    @Deprecated
    public Table<EDataType, EClass, Set<EAttribute>> geteAttributesByTypeForEClass() {
        return this.eAttributesByTypeForEClass;
    }

    public IQueryRuntimeContext getRuntimeContext() {
        return this.context.getRuntimeContext();
    }

    public QueryAnalyzer getQueryAnalyzer() {
        return this.context.getQueryAnalyzer();
    }

    public IQueryBackendHintProvider getHintProvider() {
        return this.context.getHintProvider();
    }

    public void addAdapter(ILocalSearchAdapter adapter) {
        this.adapters.add(adapter);
    }

    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.adapters.remove(adapter);
    }

    public List<ILocalSearchAdapter> getAdapters() {
        return Lists.newArrayList(this.adapters);
    }

    public IQueryBackendContext getBackendContext() {
        return this.context;
    }

    public ICache getCache() {
        return this.generalCache;
    }
}

