/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.viatra.query.runtime.localsearch.MatchingKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class MatchingFrame
extends Tuple {
    private static final String KEYS_ARRAY_SETUP_MISSING_MESSAGE = "A non-null key array has to be set up before getElements() is called.";
    private static final String KEYS_ARRAY_MUST_NOT_BE_NULL_MESSAGE = "Argument keys must not be null.";
    private Object pattern;
    private Object[] frame;
    private int[] keys;
    private Object[] parameterValues;

    public MatchingFrame(Object pattern, int frameSize) {
        this.pattern = pattern;
        this.frame = new Object[frameSize];
    }

    public MatchingFrame(MatchingFrame other) {
        this.pattern = other.pattern;
        this.frame = Arrays.copyOf(other.frame, other.frame.length);
        this.keys = (int[])(other.keys == null ? null : Arrays.copyOf(other.keys, other.keys.length));
        this.parameterValues = Arrays.copyOf(other.parameterValues, other.parameterValues.length);
    }

    public boolean setKeys(int[] keys) {
        Preconditions.checkArgument((keys != null ? 1 : 0) != 0, (Object)KEYS_ARRAY_MUST_NOT_BE_NULL_MESSAGE);
        this.keys = Arrays.copyOf(keys, keys.length);
        if (this.parameterValues != null) {
            int i = 0;
            while (i < this.parameterValues.length) {
                if (this.parameterValues[i] != null) {
                    if (this.frame[keys[i]] != null && !this.frame[keys[i]].equals(this.parameterValues[i])) {
                        return false;
                    }
                    this.frame[keys[i]] = this.parameterValues[i];
                }
                ++i;
            }
        }
        return true;
    }

    public Object getValue(int position) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        return this.frame[position];
    }

    public void setValue(int position, Object value) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        this.frame[position] = value;
    }

    public void setParameterValues(Object[] parameterValues) {
        this.parameterValues = Arrays.copyOf(parameterValues, parameterValues.length);
    }

    public boolean testAndSetValue(Integer position, Object value) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        if (this.frame[position] == null) {
            this.frame[position.intValue()] = value;
            return true;
        }
        return this.frame[position].equals(value);
    }

    public Object getPattern() {
        return this.pattern;
    }

    public MatchingKey getKey() {
        Object[] key = new Object[this.keys.length];
        int i = 0;
        while (i < this.keys.length) {
            key[i] = this.frame[this.keys[i]];
            ++i;
        }
        return new MatchingKey(key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.frame.length) {
            builder.append("frame[" + i + "]\t" + (this.frame[i] == null ? "null" : this.frame[i]).toString() + "\n");
            ++i;
        }
        return builder.toString();
    }

    public int getSize() {
        return this.frame.length;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object[] getElements() {
        Preconditions.checkState((this.keys != null ? 1 : 0) != 0, (Object)KEYS_ARRAY_SETUP_MISSING_MESSAGE);
        Object[] allElements = new Object[this.keys.length];
        int i = 0;
        while (i < this.keys.length) {
            allElements[i] = this.get(this.keys[i]);
            ++i;
        }
        return allElements;
    }
}

