/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.igraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;

public class IBiDirectionalWrapper<V>
implements IBiDirectionalGraphDataSource<V>,
IGraphObserver<V> {
    private static final long serialVersionUID = -5771114630390029106L;
    private IGraphDataSource<V> wrappedDataSource;
    private Map<V, Map<V, Integer>> incomingEdges;

    public IBiDirectionalWrapper(IGraphDataSource<V> gds) {
        this.wrappedDataSource = gds;
        this.incomingEdges = new HashMap<V, Map<V, Integer>>();
        if (gds.getAllNodes() != null) {
            for (V source : gds.getAllNodes()) {
                Map<V, Integer> targets = gds.getTargetNodes(source);
                for (Map.Entry<V, Integer> entry : targets.entrySet()) {
                    int i = 0;
                    while (i < entry.getValue()) {
                        this.edgeInserted(source, entry.getKey());
                        ++i;
                    }
                }
            }
        }
        gds.attachAsFirstObserver(this);
    }

    @Override
    public void attachObserver(IGraphObserver<V> observer) {
        this.wrappedDataSource.attachObserver(observer);
    }

    @Override
    public void attachAsFirstObserver(IGraphObserver<V> observer) {
        this.wrappedDataSource.attachAsFirstObserver(observer);
    }

    @Override
    public void detachObserver(IGraphObserver<V> observer) {
        this.wrappedDataSource.detachObserver(observer);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.wrappedDataSource.getAllNodes();
    }

    @Override
    public Map<V, Integer> getTargetNodes(V source) {
        return this.wrappedDataSource.getTargetNodes(source);
    }

    @Override
    public Map<V, Integer> getSourceNodes(V target) {
        Map<V, Integer> result = this.incomingEdges.get(target);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    @Override
    public void edgeInserted(V source, V target) {
        Integer count;
        Map<Integer, Integer> incoming = this.incomingEdges.get(target);
        if (incoming == null) {
            incoming = new HashMap<V, Integer>();
            this.incomingEdges.put((Map<Integer, Integer>)target, (Map<Map<Integer, Integer>, Integer>)incoming);
        }
        if ((count = incoming.get(source)) == null) {
            count = 0;
        }
        count = count + 1;
        incoming.put((Integer)source, count);
    }

    @Override
    public void edgeDeleted(V source, V target) {
        Integer count;
        Map<Integer, Integer> incoming = this.incomingEdges.get(target);
        if (incoming != null && (count = incoming.get(source)) != null) {
            if ((count = Integer.valueOf(count - 1)) == 0) {
                incoming.remove(source);
            } else {
                incoming.put((Integer)source, count);
            }
        }
    }

    @Override
    public void nodeInserted(V n) {
    }

    @Override
    public void nodeDeleted(V node) {
        Map<V, Integer> outgoing = this.wrappedDataSource.getTargetNodes(node);
        if (outgoing != null) {
            for (V target : outgoing.keySet()) {
                Map<V, Integer> incoming = this.incomingEdges.get(target);
                assert (incoming != null);
                incoming.remove(node);
            }
        }
        this.incomingEdges.remove(node);
    }

    public String toString() {
        return this.wrappedDataSource.toString();
    }
}

