/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.ApplicationInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.AbstractRule;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ApplicationMapping
extends AbstractRule<ApplicationInstanceMatch> {
    public ApplicationMapping(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public PriorityRuleSpecification<ApplicationInstanceMatch> getSpecification() {
        PriorityRuleSpecification _createPriorityRuleSpecification = this.createPriorityRuleSpecification();
        Procedures.Procedure1<PriorityRuleSpecification<ApplicationInstanceMatch>> _function = new Procedures.Procedure1<PriorityRuleSpecification<ApplicationInstanceMatch>>(){

            public void apply(PriorityRuleSpecification<ApplicationInstanceMatch> it) {
                try {
                    Job _appearedJob = ApplicationMapping.this.getAppearedJob();
                    Job _updateJob = ApplicationMapping.this.getUpdateJob();
                    Job _disappearedJob = ApplicationMapping.this.getDisappearedJob();
                    it.setRuleSpecification((RuleSpecification<ApplicationInstanceMatch>)Rules.newMatcherRuleSpecification((IQuerySpecification)ApplicationMapping.this.cpsXformM2M.getApplicationInstance(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _updateJob, _disappearedJob}))));
                    it.setPriority(2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return (PriorityRuleSpecification)ObjectExtensions.operator_doubleArrow(_createPriorityRuleSpecification, (Procedures.Procedure1)_function);
    }

    private Job<ApplicationInstanceMatch> getAppearedJob() {
        IMatchProcessor<ApplicationInstanceMatch> _function = new IMatchProcessor<ApplicationInstanceMatch>(){

            public void process(final ApplicationInstanceMatch match) {
                try {
                    DeploymentHost depHost = (DeploymentHost)IterableExtensions.head((Iterable)Iterables.filter(ApplicationMapping.this.cpsXformM2M.getCps2depTrace(ApplicationMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance().getAllocatedTo()), DeploymentHost.class));
                    final String appId = match.getAppInstance().getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Mapping application with ID: ");
                    _builder.append((Object)appId);
                    ApplicationMapping.this.logger.debug((Object)_builder);
                    DeploymentApplication _createDeploymentApplication = ApplicationMapping.this.depFactory.createDeploymentApplication();
                    Procedures.Procedure1<DeploymentApplication> _function = new Procedures.Procedure1<DeploymentApplication>(){

                        public void apply(DeploymentApplication it) {
                            it.setId(appId);
                        }
                    };
                    final DeploymentApplication app = (DeploymentApplication)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentApplication, (Procedures.Procedure1)_function);
                    EList _applications = depHost.getApplications();
                    _applications.add((Object)app);
                    EList _traces = ApplicationMapping.this.getRootMapping().getTraces();
                    CPS2DeploymentTrace _createCPS2DeploymentTrace = ApplicationMapping.this.traceFactory.createCPS2DeploymentTrace();
                    Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                        public void apply(CPS2DeploymentTrace it) {
                            EList _cpsElements = it.getCpsElements();
                            ApplicationInstance _appInstance = match.getAppInstance();
                            _cpsElements.add((Object)_appInstance);
                            EList _deploymentElements = it.getDeploymentElements();
                            _deploymentElements.add((Object)app);
                        }
                    };
                    CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                    _traces.add((Object)_doubleArrow);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"Mapped application with ID: ");
                    _builder_1.append((Object)appId);
                    ApplicationMapping.this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<ApplicationInstanceMatch> getUpdateJob() {
        IMatchProcessor<ApplicationInstanceMatch> _function = new IMatchProcessor<ApplicationInstanceMatch>(){

            public void process(ApplicationInstanceMatch match) {
                try {
                    boolean _notEquals;
                    DeploymentElement _depElement = ApplicationMapping.this.cpsXformM2M.getCps2depTrace(ApplicationMapping.this.engine).getOneArbitraryMatch(ApplicationMapping.this.getRootMapping(), null, (Identifiable)match.getAppInstance(), null).getDepElement();
                    DeploymentApplication depApp = (DeploymentApplication)_depElement;
                    String _id = depApp.getId();
                    String _identifier = match.getAppInstance().getIdentifier();
                    boolean bl = _notEquals = !Objects.equal((Object)_id, (Object)_identifier);
                    if (_notEquals) {
                        depApp.setId(match.getAppInstance().getIdentifier());
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }

    private Job<ApplicationInstanceMatch> getDisappearedJob() {
        IMatchProcessor<ApplicationInstanceMatch> _function = new IMatchProcessor<ApplicationInstanceMatch>(){

            public void process(ApplicationInstanceMatch match) {
                try {
                    CPS2DeploymentTrace trace = (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(ApplicationMapping.this.cpsXformM2M.getCps2depTrace(ApplicationMapping.this.engine).getAllValuesOftrace(null, (Identifiable)match.getAppInstance(), null), CPS2DeploymentTrace.class));
                    DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)trace.getDeploymentElements());
                    DeploymentApplication depApp = (DeploymentApplication)_head;
                    EList _applications = ((DeploymentHost)IterableExtensions.head(ApplicationMapping.this.cpsXformM2M.getAllocatedDeploymentApplication(ApplicationMapping.this.engine).getAllValuesOfdepHost(depApp))).getApplications();
                    _applications.remove((Object)depApp);
                    EList _traces = ApplicationMapping.this.getRootMapping().getTraces();
                    _traces.remove((Object)trace);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }
}

