/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.views.internal;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.LocalSearchDebugger;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.views.LocalSearchDebugView;

public class BreakPointListener
implements IDoubleClickListener {
    private LocalSearchDebugger localSearchDebugger;

    public BreakPointListener(LocalSearchDebugger localSearchDebugger) {
        this.localSearchDebugger = localSearchDebugger;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
        try {
            LocalSearchDebugView debuggerView = this.localSearchDebugger.getLocalSearchDebugView();
            IWorkbenchPartSite site = debuggerView.getSite();
            HashMap eventContextParameters = Maps.newHashMap();
            eventContextParameters.put("activeWorkbenchWindow", site.getWorkbenchWindow());
            eventContextParameters.put("activePart", debuggerView);
            eventContextParameters.put("activePartId", "org.eclipse.viatra.query.tooling.localsearch.ui.LocalSearchDebugView");
            eventContextParameters.put("selection", thisSelection);
            ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
            commandService.getCommand("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.localsearch.placebreakpoint").executeWithChecks(new ExecutionEvent(null, (Map)eventContextParameters, null, null));
        }
        catch (Exception e) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)"Error setting up breakpoint", (Throwable)e);
        }
    }
}

