/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableJavaModelAction(Shell shell, Object element) {
        if (!(element instanceof IPackageFragment) && !(element instanceof IPackageFragmentRoot)) {
            return false;
        }
        IResource resource = ResourceUtil.getResource(element);
        if (resource == null || !(resource instanceof IFolder) || !resource.isLinked()) {
            return false;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_not_possible, (String)ActionMessages.ActionUtil_no_linked);
        return true;
    }

    public static boolean isProcessable(JavaEditor editor) {
        if (editor == null) {
            return true;
        }
        Shell shell = editor.getSite().getShell();
        ITypeRoot input = SelectionConverter.getInput(editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, (IJavaElement)input);
    }

    public static boolean isProcessable(Shell shell, IJavaElement element) {
        if (element == null) {
            return true;
        }
        if (ActionUtil.isOnBuildPath(element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IJavaElement element) {
        IProject resourceProject;
        block7: {
            IJavaProject project;
            block6: {
                if (element.getElementType() == 2) {
                    return true;
                }
                project = element.getJavaProject();
                try {
                    if (project.isOnClasspath(element)) break block6;
                    return false;
                }
                catch (CoreException coreException) {}
            }
            resourceProject = project.getProject();
            if (resourceProject != null) break block7;
            return false;
        }
        IProjectNature nature = resourceProject.getNature("org.eclipse.jdt.core.javanature");
        if (nature != null) {
            return true;
        }
        return false;
    }

    public static boolean areProcessable(Shell shell, IJavaElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!ActionUtil.isOnBuildPath(elements[i])) {
                MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)Messages.format(ActionMessages.ActionUtil_notOnBuildPath_resource_message, new Object[]{BasicElementLabels.getPathLabel((IPath)elements[i].getPath(), (boolean)false)}));
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEditable(JavaEditor editor, Shell shell, IJavaElement element) {
        if (editor != null) {
            ITypeRoot input = SelectionConverter.getInput(editor);
            if (input != null && input.equals(element.getAncestor(5))) {
                return ActionUtil.isEditable(editor);
            }
            return ActionUtil.isEditable(editor) && ActionUtil.isEditable(shell, element);
        }
        return ActionUtil.isEditable(shell, element);
    }

    public static boolean isEditable(JavaEditor editor) {
        if (!ActionUtil.isProcessable(editor)) {
            return false;
        }
        return editor.validateEditorInputState();
    }

    public static boolean isEditable(Shell shell, IJavaElement element) {
        IResource resource;
        if (!ActionUtil.isProcessable(shell, element)) {
            return false;
        }
        IJavaElement cu = element.getAncestor(5);
        if (cu != null && (resource = cu.getResource()) != null && resource.isDerived(512)) {
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            if (!store.getBoolean("warn_if_input_derived")) {
                return true;
            }
            MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)ActionMessages.ActionUtil_warning_derived_title, (String)Messages.format(ActionMessages.ActionUtil_warning_derived_message, BasicElementLabels.getPathLabel((IPath)resource.getFullPath(), (boolean)false)), (String)ActionMessages.ActionUtil_warning_derived_dontShowAgain, (boolean)false, null, null);
            EditorsUI.getPreferenceStore().setValue("warn_if_input_derived", !toggleDialog.getToggleState());
            return toggleDialog.getReturnCode() == 2;
        }
        return true;
    }
}

