/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.interfaces.CrossingReducer;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreedyCrossingReducer
implements CrossingReducer {
    private final Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();
    private List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
    private Map<Integer, Integer> crossesForLayers = new IdentityHashMap<Integer, Integer>();

    private ArrayList<NodeLayout> unionOfNodes(NodeLayout[] a, NodeLayout[] b) {
        ArrayList<NodeLayout> res = new ArrayList<NodeLayout>();
        int i = 0;
        while (i < a.length) {
            res.add(a[i]);
            ++i;
        }
        i = 0;
        while (i < b.length) {
            if (!res.contains(b[i])) {
                res.add(b[i]);
            }
            ++i;
        }
        return res;
    }

    private int numberOfCrosses(NodeWrapper nodeA, NodeWrapper nodeB) {
        int numOfCrosses = 0;
        if (nodeA.equals(nodeB)) {
            return 0;
        }
        ArrayList<NodeLayout> adjacentNodesOfA = this.unionOfNodes(nodeA.node.getPredecessingNodes(), nodeA.node.getSuccessingNodes());
        ArrayList<NodeLayout> adjacentNodesOfB = this.unionOfNodes(nodeB.node.getPredecessingNodes(), nodeB.node.getSuccessingNodes());
        for (NodeLayout aNode : adjacentNodesOfA) {
            ArrayList<Integer> alreadyCrossed = new ArrayList<Integer>();
            NodeWrapper aNodeWrapper = this.map.get(aNode);
            int i = 0;
            while (i < adjacentNodesOfB.size()) {
                NodeWrapper nw = this.map.get(adjacentNodesOfB.get(i));
                if (!alreadyCrossed.contains(i) && nw != null && (nw.layer > nodeA.layer && aNodeWrapper.layer > nodeA.layer || nw.layer < nodeA.layer && aNodeWrapper.layer < nodeA.layer)) {
                    if (nodeA.index < nodeB.index) {
                        if (aNodeWrapper.index > nw.index) {
                            ++numOfCrosses;
                            alreadyCrossed.add(i);
                        } else if (nw.index == aNodeWrapper.index) {
                            if (nodeA.index >= nw.index) {
                                if (aNodeWrapper.layer > nw.layer && nodeA.layer < nw.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            } else if (nodeB.index <= nw.index && (aNodeWrapper.layer > nw.layer && aNodeWrapper.layer < nodeB.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer)) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            }
                        }
                    } else if (nodeA.index > nodeB.index) {
                        if (aNodeWrapper.index < nw.index) {
                            ++numOfCrosses;
                            alreadyCrossed.add(i);
                        } else if (nw.index == aNodeWrapper.index) {
                            if (nodeB.index >= nw.index) {
                                if (aNodeWrapper.layer > nw.layer && nodeB.layer > aNodeWrapper.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            } else if (nodeA.index <= nw.index && (aNodeWrapper.layer > nw.layer && nw.layer > nodeA.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer)) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return numOfCrosses;
    }

    private boolean greedyHeuristic(List<NodeWrapper> layer) {
        boolean res = false;
        if (layer.size() > 1) {
            int i = 0;
            while (i < layer.size() - 1) {
                int num2;
                int num1;
                if (!(layer.get((int)i).node == null || layer.get((int)(i + 1)).node == null || (num1 = this.numberOfCrosses(layer.get(i), layer.get(i + 1))) <= (num2 = this.numberOfCrosses(layer.get(i + 1), layer.get(i))) && (num1 != num2 || num1 <= 0) || this.crossesForLayers.containsKey(layer.get((int)i).layer) && this.crossesForLayers.get(layer.get((int)i).layer) <= num2)) {
                    this.crossesForLayers.put(layer.get((int)i).layer, num2);
                    res = true;
                    int level = layer.get((int)0).layer;
                    NodeWrapper tmp = this.layers.get(level).get(i);
                    int tmpindex = this.layers.get((int)level).get((int)i).index;
                    this.layers.get((int)level).get((int)i).index = this.layers.get((int)level).get((int)(i + 1)).index;
                    this.layers.get(level).set(i, this.layers.get(level).get(i + 1));
                    this.layers.get((int)level).get((int)(i + 1)).index = tmpindex;
                    this.layers.get(level).set(i + 1, tmp);
                }
                ++i;
            }
        }
        return res;
    }

    @Override
    public void crossReduction(List<List<NodeWrapper>> nodes) {
        this.crossesForLayers.clear();
        this.layers = nodes;
        for (List<NodeWrapper> layer : nodes) {
            for (NodeWrapper node : layer) {
                this.map.put(node.node, node);
            }
        }
        int iteration = 0;
        boolean change = false;
        while (iteration < 3) {
            change = false;
            int i = 0;
            while (i < nodes.size()) {
                if (this.greedyHeuristic(this.layers.get(i))) {
                    change = true;
                }
                ++i;
            }
            if (change) continue;
            ++iteration;
        }
    }
}

