/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Node;

public final class Graph {
    private final List<Node> nodes;
    private final List<Edge> edges;
    private final Map<String, Object> attrs;

    public Graph(Map<String, Object> attrs, List<Node> nodes, List<Edge> edges) {
        this.attrs = attrs;
        this.nodes = nodes;
        this.edges = edges;
    }

    public Map<String, Object> getAttrs() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public List<Edge> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public String toString() {
        return String.format("Graph {%s nodes, %s edges}", this.nodes.size(), this.edges.size());
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Graph)) {
            return false;
        }
        Graph thatGraph = (Graph)that;
        boolean attrsEqual = this.getAttrs().equals(thatGraph.getAttrs());
        boolean nodesEqual = this.getNodes().equals(thatGraph.getNodes());
        boolean edgesEqual = this.getEdges().equals(thatGraph.getEdges());
        return attrsEqual && nodesEqual && edgesEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAttrs().hashCode();
        result = 31 * result + this.getNodes().hashCode();
        result = 31 * result + this.getEdges().hashCode();
        return result;
    }

    public static class Attr {

        public static enum Key {
            NODE_STYLE,
            EDGE_STYLE,
            LABEL,
            STYLE,
            ID,
            IMAGE,
            LAYOUT,
            GRAPH_TYPE;

        }

        public static enum Value {
            LINE_DASH,
            LINE_DOT,
            LINE_SOLID,
            LINE_DASHDOT,
            LINE_DASHDOTDOT,
            GRAPH_DIRECTED,
            GRAPH_UNDIRECTED,
            CONNECTIONS_DIRECTED,
            NONE;

        }
    }

    public static class Builder {
        private List<Node> nodes = new ArrayList<Node>();
        private List<Edge> edges = new ArrayList<Edge>();
        private Map<String, Object> attrs = new HashMap<String, Object>();

        public Builder nodes(Node ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
            return this;
        }

        public Builder edges(Edge ... edges) {
            this.edges.addAll(Arrays.asList(edges));
            return this;
        }

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Builder attr(Attr.Key attr, Object value) {
            return this.attr(attr.toString(), value);
        }

        public Graph build() {
            return new Graph(this.attrs, this.nodes, this.edges);
        }
    }
}

