/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.AddContextDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.CreateSessionDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.DestroyConfirmDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.EnableChannelDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.EnableEventsDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.GetEventInfoDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IAddContextDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableChannelDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableEventsDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProbeEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TargetNodeConnectedCondition;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.tracecompass.tmf.ui.tests.shared.IWaitCondition;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlKernelSessionTest {
    private static final String TEST_STREAM = "CreateTreeTest.cfg";
    private static final String SCEN_SCENARIO3_TEST = "Scenario3";
    private TraceControlTestFacility fFacility;
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    private @NonNull TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        this.fFacility.dispose();
    }

    @Test
    public void testTraceSessionTree() throws Exception {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        this.fFacility.waitForJobs();
        this.fFacility.executeCommand((ITraceControlComponent)node, "connect");
        WaitUtils.waitUntil((IWaitCondition)new TargetNodeConnectedCondition(node));
        Assert.assertEquals((Object)TargetNodeState.CONNECTED, (Object)node.getTargetNodeState());
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)new CreateSessionDialogStub());
        TraceControlDialogFactory.getInstance().setGetEventInfoDialog((IGetEventInfoDialog)new GetEventInfoDialogStub());
        TraceControlDialogFactory.getInstance().setConfirmDialog((IConfirmDialog)new DestroyConfirmDialogStub());
        this.fProxy.setScenario("SessionHandling");
        TraceSessionComponent session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120314-132824", (Object)session.getSessionPath());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        this.fProxy.setScenario(SCEN_SCENARIO3_TEST);
        EnableChannelDialogStub channelStub = new EnableChannelDialogStub();
        channelStub.setDomain(TraceDomainType.KERNEL);
        TraceControlDialogFactory.getInstance().setEnableChannelDialog((IEnableChannelDialog)channelStub);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableChannelOnSession");
        ITraceControlComponent[] domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        Assert.assertEquals((Object)"Kernel", (Object)domains[0].getName());
        ITraceControlComponent[] channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        TraceChannelComponent channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"mychannel", (Object)channel.getName());
        Assert.assertEquals((long)4L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"splice()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channel.getOutputType());
        Assert.assertEquals((Object)true, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)16384L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)100L, (long)channel.getSwitchTimer());
        ChannelInfo info = (ChannelInfo)channelStub.getChannelInfo();
        info.setName("mychannel2");
        info.setOverwriteMode(false);
        info.setSubBufferSize(32768L);
        info.setNumberOfSubBuffers(2);
        info.setSwitchTimer(100L);
        info.setReadTimer(200L);
        channelStub.setChannelInfo(info);
        this.fFacility.executeCommand(domains[0], "enableChannelOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)2L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[1] instanceof TraceChannelComponent));
        channel = (TraceChannelComponent)channels[1];
        Assert.assertEquals((Object)"mychannel2", (Object)channel.getName());
        Assert.assertEquals((long)2L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"splice()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channel.getOutputType());
        Assert.assertEquals((Object)false, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)32768L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)100L, (long)channel.getSwitchTimer());
        EnableEventsDialogStub eventsDialogStub = new EnableEventsDialogStub();
        eventsDialogStub.setIsTracePoints(true);
        ArrayList<String> events = new ArrayList<String>();
        events.add("sched_kthread_stop");
        events.add("sched_kthread_stop_ret");
        eventsDialogStub.setNames(events);
        eventsDialogStub.setDomain(TraceDomainType.KERNEL);
        TraceControlDialogFactory.getInstance().setEnableEventsDialog((IEnableEventsDialog)eventsDialogStub);
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)2L, (long)channels.length);
        this.fFacility.executeCommand(channels, "disableChannel");
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)((TraceChannelComponent)channels[0]).getState());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)((TraceChannelComponent)channels[1]).getState());
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)2L, (long)channels.length);
        this.fFacility.executeCommand(channels, "enableChannel");
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)((TraceChannelComponent)channels[0]).getState());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)((TraceChannelComponent)channels[1]).getState());
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableEventOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)3L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[2] instanceof TraceChannelComponent));
        channel = (TraceChannelComponent)channels[2];
        Assert.assertEquals((Object)"channel0", (Object)channel.getName());
        ITraceControlComponent[] channel0Events = channel.getChildren();
        Assert.assertEquals((long)2L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        Assert.assertTrue((boolean)(channel0Events[1] instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"sched_kthread_stop_ret", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        event = (TraceEventComponent)channel0Events[1];
        Assert.assertEquals((Object)"sched_kthread_stop", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        events.add("sched_wakeup_new");
        eventsDialogStub.setNames(events);
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)3L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[2] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[2];
        Assert.assertEquals((Object)"sched_wakeup_new", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setNames(events);
        eventsDialogStub.setIsAllTracePoints(true);
        this.fFacility.executeCommand(channels[1], "enableEventOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[1];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)3L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        Assert.assertTrue((boolean)(channel0Events[1] instanceof TraceEventComponent));
        Assert.assertTrue((boolean)(channel0Events[2] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"sched_kthread_stop_ret", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        event = (TraceEventComponent)channel0Events[1];
        Assert.assertEquals((Object)"sched_kthread_stop", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        event = (TraceEventComponent)channel0Events[2];
        Assert.assertEquals((Object)"sched_wakeup_new", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setIsTracePoints(false);
        eventsDialogStub.setIsAllTracePoints(false);
        eventsDialogStub.setIsSysCalls(true);
        this.fFacility.executeCommand(channels[0], "enableEventOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        channel = (TraceChannelComponent)channels[0];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)1L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"syscalls", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.SYSCALL, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)4L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"syscalls", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.SYSCALL, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableEventOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)4L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"syscalls", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.SYSCALL, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setIsSysCalls(false);
        eventsDialogStub.setIsDynamicProbe(true);
        eventsDialogStub.setDynamicProbe("0xc0101280");
        eventsDialogStub.setProbeEventName("myevent1");
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)5L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceProbeEventComponent));
        TraceProbeEventComponent probeEvent = (TraceProbeEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent1", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.PROBE, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertNull((Object)probeEvent.getOffset());
        Assert.assertEquals((Object)"0xc0101280", (Object)probeEvent.getAddress());
        Assert.assertNull((Object)probeEvent.getSymbol());
        eventsDialogStub.setIsDynamicProbe(true);
        eventsDialogStub.setDynamicProbe("init_post");
        eventsDialogStub.setProbeEventName("myevent2");
        this.fFacility.executeCommand(channels[2], "enableEventOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)6L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceProbeEventComponent));
        probeEvent = (TraceProbeEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent2", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.PROBE, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertEquals((Object)"0x0", (Object)probeEvent.getOffset());
        Assert.assertNull(null, (Object)probeEvent.getAddress());
        Assert.assertEquals((Object)"init_post", (Object)probeEvent.getSymbol());
        eventsDialogStub.setIsDynamicProbe(true);
        eventsDialogStub.setDynamicProbe("init_post:0x1000");
        eventsDialogStub.setProbeEventName("myevent3");
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableEventOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)7L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceProbeEventComponent));
        probeEvent = (TraceProbeEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent3", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.PROBE, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertEquals((Object)"0x1000", (Object)probeEvent.getOffset());
        Assert.assertNull(null, (Object)probeEvent.getAddress());
        Assert.assertEquals((Object)"init_post", (Object)probeEvent.getSymbol());
        eventsDialogStub.setIsDynamicProbe(false);
        eventsDialogStub.setDynamicProbe(null);
        eventsDialogStub.setProbeEventName(null);
        eventsDialogStub.setIsFunctionProbe(true);
        eventsDialogStub.setFunctionEventName("myevent4");
        eventsDialogStub.setFunctionProbe("create_dev");
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableEventOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)8L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceProbeEventComponent));
        probeEvent = (TraceProbeEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent4", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.FUNCTION, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertEquals((Object)"0x0", (Object)probeEvent.getOffset());
        Assert.assertNull(null, (Object)probeEvent.getAddress());
        Assert.assertEquals((Object)"create_dev", (Object)probeEvent.getSymbol());
        eventsDialogStub.setIsFunctionProbe(true);
        eventsDialogStub.setFunctionEventName("myevent5");
        eventsDialogStub.setFunctionProbe("create_dev:0x2000");
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)9L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceProbeEventComponent));
        probeEvent = (TraceProbeEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent5", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.PROBE, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertEquals((Object)"0x2000", (Object)probeEvent.getOffset());
        Assert.assertNull(null, (Object)probeEvent.getAddress());
        Assert.assertEquals((Object)"create_dev", (Object)probeEvent.getSymbol());
        eventsDialogStub.setIsFunctionProbe(true);
        eventsDialogStub.setFunctionEventName("myevent");
        eventsDialogStub.setFunctionProbe("create_dev:0x2000");
        this.fFacility.executeCommand(channels[0], "enableEventOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)2L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceProbeEventComponent));
        probeEvent = (TraceProbeEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.PROBE, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertEquals((Object)"0x2000", (Object)probeEvent.getOffset());
        Assert.assertNull(null, (Object)probeEvent.getAddress());
        Assert.assertEquals((Object)"create_dev", (Object)probeEvent.getSymbol());
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        AddContextDialogStub addContextStub = new AddContextDialogStub();
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.add("prio");
        contexts.add("perf:branch-misses");
        contexts.add("perf:cache-misses");
        addContextStub.setContexts(contexts);
        TraceControlDialogFactory.getInstance().setAddContextDialog((IAddContextDialog)addContextStub);
        this.fFacility.executeCommand(domains[0], "addContextOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        try {
            addContextStub.setContexts(contexts);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Exception caught - unknown context");
        }
        this.fFacility.executeCommand((ITraceControlComponent)channel, "addContextOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        event = (TraceEventComponent)channel0Events[6];
        this.fFacility.executeCommand((ITraceControlComponent)event, "addContextOnEvent");
        this.fFacility.executeCommand((ITraceControlComponent)node, "refresh");
        groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        Assert.assertEquals((long)3L, (long)groups[0].getChildren().length);
        Assert.assertEquals((long)1L, (long)groups[1].getChildren().length);
        Assert.assertEquals((long)1L, (long)groups[1].getChildren()[0].getChildren().length);
        Assert.assertEquals((long)3L, (long)groups[1].getChildren()[0].getChildren()[0].getChildren().length);
        Assert.assertEquals((long)2L, (long)groups[1].getChildren()[0].getChildren()[0].getChildren()[0].getChildren().length);
        this.fProxy.setScenario("SessionHandling");
        session = (TraceSessionComponent)groups[1].getChildren()[0];
        this.fFacility.startSession(session);
        Assert.assertEquals((Object)TraceSessionState.ACTIVE, (Object)session.getSessionState());
        this.fFacility.stopSession(session);
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fFacility.executeCommand((ITraceControlComponent)node, "disconnect");
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        this.fFacility.executeCommand((ITraceControlComponent)node, "delete");
        Assert.assertEquals((long)0L, (long)this.fFacility.getControlView().getTraceControlRoot().getChildren().length);
    }
}

