/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.fsm.compile;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlLocationCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IBaseQuarkProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventField;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventName;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValuePool;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueQuery;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueSelf;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TmfXmlStateAttributeAndLocationCuTest {
    private static final @NonNull AnalysisCompilationData ANALYSIS_DATA = new AnalysisCompilationData();

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Null state attribute", "<stateAttribute type=\"null\" />", true}, {"Constant valid", "<stateAttribute type=\"constant\" value=\"42\" />", true}, {"Constant invalid", "<stateAttribute type=\"constant\" />", false}, {"Event field valid", "<stateAttribute type=\"eventField\" value=\"myfield\" />", true}, {"Event field invalid", "<stateAttribute type=\"eventField\" />", false}, {"Event name valid 1", "<stateAttribute type=\"eventName\" />", true}, {"Event name valid 2", "<stateAttribute type=\"eventName\" value=\"ignored\" />", true}, {"Query", "<stateAttribute type=\"query\" ><stateAttribute type=\"constant\" value=\"queryPath\"/></stateAttribute>", true}, {"Query no children", "<stateAttribute type=\"query\" />", false}, {"Query with invalid children", "<stateAttribute type=\"query\" ><stateAttribute type=\"constant\" /></stateAttribute>", false}, {"Self", "<stateAttribute type=\"self\" />", true}, {"Pool", "<stateAttribute type=\"pool\" />", true});
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testValidStateAttributeCompilation() throws SAXException, IOException, ParserConfigurationException {
        String[] validStrings = new String[]{"<stateAttribute type=\"null\" />", "<stateAttribute type=\"constant\" value=\"42\" />", "<stateAttribute type=\"eventField\" value=\"myfield\" />", "<stateAttribute type=\"eventName\" />", "<stateAttribute type=\"eventName\" value=\"ignored\" />", "<stateAttribute type=\"query\" ><stateAttribute type=\"constant\" value=\"queryPath\"/></stateAttribute>", "<stateAttribute type=\"self\" />", "<stateAttribute type=\"pool\" />"};
        DataDrivenValue[] generated = new DataDrivenValue[]{TmfXmlTestUtils.NULL_VALUE, new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"42"), new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, "myfield"), new DataDrivenValueEventName(null), new DataDrivenValueEventName(null), new DataDrivenValueQuery(null, ITmfStateValue.Type.NULL, new DataDrivenStateSystemPath((List)ImmutableList.of((Object)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"queryPath")), IBaseQuarkProvider.IDENTITY_BASE_QUARK)), new DataDrivenValueSelf(ITmfStateValue.Type.NULL), DataDrivenValuePool.getInstance()};
        int i = 0;
        while (i < validStrings.length) {
            String validString = validStrings[i];
            DataDrivenValue runtimeObj = generated[i];
            Element xmlElement = TmfXmlTestUtils.getXmlElement("stateAttribute", validString);
            Assert.assertNotNull((Object)xmlElement);
            @NonNull List compileAttribute = TmfXmlStateValueCu.compileAttribute((AnalysisCompilationData)ANALYSIS_DATA, (Element)xmlElement);
            Assert.assertNotNull((String)validString, (Object)compileAttribute);
            Assert.assertEquals((String)"Number of attributes", (long)1L, (long)compileAttribute.size());
            TmfXmlStateValueCu value = (TmfXmlStateValueCu)compileAttribute.get(0);
            Assert.assertEquals((String)"Expected attribute", (Object)runtimeObj, (Object)value.generate());
            ++i;
        }
    }

    @Test
    public void testInvalidStateAttributeCompilation() throws SAXException, IOException, ParserConfigurationException {
        String[] invalidStrings;
        String[] stringArray = invalidStrings = new String[]{"<stateAttribute type=\"constant\" />", "<stateAttribute type=\"eventField\" />", "<stateAttribute type=\"query\" />", "<stateAttribute type=\"query\" ><stateAttribute type=\"constant\" /></stateAttribute>", "<stateAttribute type=\"location\" value=\"undefined\" />"};
        int n = invalidStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String invalidString = stringArray[n2];
            Element xmlElement = TmfXmlTestUtils.getXmlElement("stateAttribute", invalidString);
            Assert.assertNotNull((Object)xmlElement);
            Assert.assertNull((String)invalidString, (Object)TmfXmlStateValueCu.compileAttribute((AnalysisCompilationData)ANALYSIS_DATA, (Element)xmlElement));
            ++n2;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testValidLocationCompilation() throws SAXException, IOException, ParserConfigurationException {
        String locName = "loc";
        String location = "<location id=\"" + locName + "\"><stateAttribute type=\"constant\" value=\"abc\" /><stateAttribute type=\"eventField\" value=\"myField\" /></location>";
        AnalysisCompilationData data = new AnalysisCompilationData();
        Element xmlElement = TmfXmlTestUtils.getXmlElement("location", location);
        Assert.assertNotNull((Object)xmlElement);
        TmfXmlLocationCu locationCu = TmfXmlLocationCu.compile((AnalysisCompilationData)data, (Element)xmlElement);
        Assert.assertNotNull((String)"location", (Object)locationCu);
        data.addLocation(locName, locationCu);
        String attributeXml = "<stateAttribute type=\"location\" value=\"" + locName + "\" />";
        xmlElement = TmfXmlTestUtils.getXmlElement("stateAttribute", attributeXml);
        Assert.assertNotNull((Object)xmlElement);
        @NonNull List attribute = TmfXmlStateValueCu.compileAttribute((AnalysisCompilationData)data, (Element)xmlElement);
        Assert.assertNotNull((String)"Location attribute compilation", (Object)attribute);
        Assert.assertEquals((String)"Attribute count", (long)2L, (long)attribute.size());
        ImmutableList expected = ImmutableList.of((Object)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"abc"), (Object)new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, "myField"));
        List actual = attribute.stream().map(a -> a.generate()).collect(Collectors.toList());
        Assert.assertEquals((String)"Location generated", (Object)expected, actual);
    }
}

