/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Certification;
import org.eclipse.equinox.internal.p2.discovery.model.FeatureFilter;
import org.eclipse.equinox.internal.p2.discovery.model.Group;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.discovery.model.ValidationException;

public class ConnectorDiscoveryExtensionReader {
    private static final String P2_FEATURE_GROUP_SUFFIX = ".feature.group";
    public static final String EXTENSION_POINT_ID = "org.eclipse.mylyn.discovery.core.connectorDiscovery";
    public static final String CONNECTOR_DESCRIPTOR = "connectorDescriptor";
    public static final String CONNECTOR_CATEGORY = "connectorCategory";
    public static final String CERTIFICATION = "certification";
    public static final String ICON = "icon";
    public static final String OVERVIEW = "overview";
    public static final String FEATURE_FILTER = "featureFilter";
    public static final String GROUP = "group";
    public static Tag DOCUMENT = new Tag("document", Messages.ConnectorDiscoveryExtensionReader_Documents);
    public static Tag TASK = new Tag("task", Messages.ConnectorDiscoveryExtensionReader_Tasks);
    public static Tag VCS = new Tag("vcs", Messages.ConnectorDiscoveryExtensionReader_Version_Control);
    public static final Tag[] DEFAULT_TAGS = new Tag[]{DOCUMENT, TASK, VCS};
    private Map<String, Tag> tagById = new HashMap<String, Tag>();

    public static Tag fromValue(String value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        Tag[] tagArray = DEFAULT_TAGS;
        int n = DEFAULT_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            Tag tag = tagArray[n2];
            if (tag.getValue().equals(value)) {
                return tag;
            }
            ++n2;
        }
        throw new IllegalArgumentException(value);
    }

    public Set<Tag> getTags() {
        return new HashSet<Tag>(this.tagById.values());
    }

    private Tag getTag(String id) {
        if (id == null) {
            return null;
        }
        Tag result = this.tagById.get(id);
        if (result != null) {
            return result;
        }
        Tag[] tagArray = DEFAULT_TAGS;
        int n = DEFAULT_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            Tag tag = tagArray[n2];
            if (tag.getValue().equals(id)) {
                this.tagById.put(id, tag);
                return tag;
            }
            ++n2;
        }
        result = new Tag(id, id);
        this.tagById.put(id, result);
        return result;
    }

    public CatalogItem readConnectorDescriptor(IConfigurationElement element) throws ValidationException {
        return this.readConnectorDescriptor(element, CatalogItem.class);
    }

    public <T extends CatalogItem> T readConnectorDescriptor(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        int n;
        CatalogItem connectorDescriptor;
        try {
            connectorDescriptor = (CatalogItem)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            String kinds = element.getAttribute("kind");
            if (kinds != null) {
                String[] akinds;
                String[] stringArray = akinds = kinds.split("\\s*,\\s*");
                int n2 = akinds.length;
                n = 0;
                while (n < n2) {
                    String kind = stringArray[n];
                    Tag tag = this.getTag(kind);
                    if (tag != null) {
                        connectorDescriptor.addTag(tag);
                    }
                    ++n;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_value_kind);
        }
        connectorDescriptor.setName(element.getAttribute("name"));
        connectorDescriptor.setProvider(element.getAttribute("provider"));
        connectorDescriptor.setLicense(element.getAttribute("license"));
        connectorDescriptor.setDescription(element.getAttribute("description"));
        connectorDescriptor.setSiteUrl(element.getAttribute("siteUrl"));
        connectorDescriptor.setId(element.getAttribute("id"));
        connectorDescriptor.setCategoryId(element.getAttribute("categoryId"));
        connectorDescriptor.setCertificationId(element.getAttribute("certificationId"));
        connectorDescriptor.setPlatformFilter(element.getAttribute("platformFilter"));
        connectorDescriptor.setGroupId(element.getAttribute("groupId"));
        IConfigurationElement[] children = element.getChildren("iu");
        if (children.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = children;
            n = children.length;
            int n3 = 0;
            while (n3 < n) {
                child = iConfigurationElementArray[n3];
                connectorDescriptor.getInstallableUnits().add(this.getFeatureId(child.getAttribute("id")));
                ++n3;
            }
        } else {
            connectorDescriptor.getInstallableUnits().add(this.getFeatureId(connectorDescriptor.getId()));
        }
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(FEATURE_FILTER);
        n = iConfigurationElementArray.length;
        int n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            FeatureFilter featureFilterItem = this.readFeatureFilter(child);
            featureFilterItem.setItem(connectorDescriptor);
            connectorDescriptor.getFeatureFilter().add(featureFilterItem);
            ++n4;
        }
        iConfigurationElementArray = element.getChildren(ICON);
        n = iConfigurationElementArray.length;
        n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            Icon iconItem = this.readIcon(child);
            if (connectorDescriptor.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            connectorDescriptor.setIcon(iconItem);
            ++n4;
        }
        iConfigurationElementArray = element.getChildren(OVERVIEW);
        n = iConfigurationElementArray.length;
        n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            Overview overviewItem = this.readOverview(child);
            overviewItem.setItem(connectorDescriptor);
            if (connectorDescriptor.getOverview() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_overview);
            }
            connectorDescriptor.setOverview(overviewItem);
            ++n4;
        }
        connectorDescriptor.validate();
        return (T)connectorDescriptor;
    }

    private String getFeatureId(String id) {
        if (!id.endsWith(P2_FEATURE_GROUP_SUFFIX)) {
            return id + P2_FEATURE_GROUP_SUFFIX;
        }
        return id;
    }

    public CatalogCategory readConnectorCategory(IConfigurationElement element) throws ValidationException {
        return this.readConnectorCategory(element, CatalogCategory.class);
    }

    public <T extends CatalogCategory> T readConnectorCategory(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        CatalogCategory connectorCategory;
        try {
            connectorCategory = (CatalogCategory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        connectorCategory.setId(element.getAttribute("id"));
        connectorCategory.setName(element.getAttribute("name"));
        connectorCategory.setDescription(element.getAttribute("description"));
        connectorCategory.setRelevance(element.getAttribute("relevance"));
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ICON);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Icon iconItem = this.readIcon(child);
            if (connectorCategory.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            connectorCategory.setIcon(iconItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren(OVERVIEW);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Overview overviewItem = this.readOverview(child);
            overviewItem.setCategory(connectorCategory);
            if (connectorCategory.getOverview() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_overview);
            }
            connectorCategory.setOverview(overviewItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren(GROUP);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Group groupItem = this.readGroup(child);
            groupItem.setCategory(connectorCategory);
            connectorCategory.getGroup().add(groupItem);
            ++n2;
        }
        connectorCategory.validate();
        return (T)connectorCategory;
    }

    public <T extends Certification> T readCertification(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        Certification certification;
        try {
            certification = (Certification)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        certification.setId(element.getAttribute("id"));
        certification.setName(element.getAttribute("name"));
        certification.setUrl(element.getAttribute("url"));
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ICON);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Icon iconItem = this.readIcon(child);
            if (certification.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            certification.setIcon(iconItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren("description");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            certification.setDescription(child.getValue());
            ++n2;
        }
        certification.validate();
        return (T)certification;
    }

    public Icon readIcon(IConfigurationElement element) {
        Icon icon = new Icon();
        icon.setImage16(element.getAttribute("image16"));
        icon.setImage32(element.getAttribute("image32"));
        icon.setImage48(element.getAttribute("image48"));
        icon.setImage64(element.getAttribute("image64"));
        icon.setImage128(element.getAttribute("image128"));
        icon.validate();
        return icon;
    }

    public Overview readOverview(IConfigurationElement element) {
        Overview overview = new Overview();
        overview.setSummary(element.getAttribute("summary"));
        overview.setUrl(element.getAttribute("url"));
        overview.setScreenshot(element.getAttribute("screenshot"));
        overview.validate();
        return overview;
    }

    public FeatureFilter readFeatureFilter(IConfigurationElement element) throws ValidationException {
        FeatureFilter featureFilter = new FeatureFilter();
        featureFilter.setFeatureId(element.getAttribute("featureId"));
        featureFilter.setVersion(element.getAttribute("version"));
        featureFilter.validate();
        return featureFilter;
    }

    public Group readGroup(IConfigurationElement element) throws ValidationException {
        Group group = new Group();
        group.setId(element.getAttribute("id"));
        group.validate();
        return group;
    }
}

