/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.snapshot.StateSnapshot;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotTest {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSimpleSnapshot() throws IOException {
        Path dir = null;
        try {
            dir = (Path)NonNullUtils.checkNotNull((Object)Files.createTempDirectory("ss-serialization-test", new FileAttribute[0]));
            String ssid = "test-ssid";
            IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)ssid, (long)4L);
            ITmfStateSystemBuilder ssb = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
            List<@NonNull @NonNull List> attributes = Arrays.asList(Arrays.asList("Threads"), Arrays.asList("Threads", "1000"), Arrays.asList("Threads", "1000", "Status"), Arrays.asList("Threads", "2000"), Arrays.asList("Threads", "2000", "Status"), Arrays.asList("Threads", "2000", "PPID"), Arrays.asList("Threads", "2000", "air pressure"));
            LinkedHashMap<@NonNull List<@NonNull String>, @Nullable Object> expected = new LinkedHashMap<List<String>, Object>();
            expected.put(attributes.get(0), null);
            expected.put(attributes.get(1), null);
            expected.put(attributes.get(2), null);
            expected.put(attributes.get(3), null);
            expected.put(attributes.get(4), null);
            expected.put(attributes.get(5), null);
            expected.put(attributes.get(6), null);
            SnapshotTest.populateSs(ssb, expected, 0L);
            expected.put(attributes.get(2), "Running");
            expected.put(attributes.get(4), 1);
            expected.put(attributes.get(5), 1000L);
            expected.put(attributes.get(6), 101.3);
            SnapshotTest.populateSs(ssb, expected, 5L);
            SnapshotTest.populateSs(ssb, expected, 10L);
            ssb.closeHistory(100L);
            StateSnapshot snapshot = new StateSnapshot((ITmfStateSystem)ssb, 6L, 0);
            snapshot.write(dir);
            StateSnapshot results = StateSnapshot.read((Path)dir, (String)ssid);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)0L, (long)results.getVersion());
            Assert.assertEquals((Object)ssid, (Object)results.getSsid());
            LinkedHashMap<List, Object> resultStates = new LinkedHashMap<List, Object>();
            for (Map.Entry result : results.getStates().entrySet()) {
                ITmfStateInterval value = (ITmfStateInterval)result.getValue();
                Assert.assertNotNull((String)String.valueOf(result.getKey()), (Object)value);
                resultStates.put((List)result.getKey(), value.getValue());
            }
            Assert.assertEquals(expected, resultStates);
        }
        finally {
            if (dir != null) {
                FileUtils.deleteQuietly((File)dir.toFile());
            }
        }
    }

    private static void populateSs(ITmfStateSystemBuilder ssb, Map<@NonNull List<@NonNull String>, @Nullable Object> expected, long start) {
        for (Map.Entry<List<String>, Object> entry : expected.entrySet()) {
            List<@NonNull String> key = Objects.requireNonNull(entry.getKey());
            int quark = ssb.getQuarkAbsoluteAndAdd(key.toArray(new String[0]));
            ssb.modifyAttribute(start, entry.getValue(), quark);
        }
    }
}

