/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.rocm.core.exatracer.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTrace;
import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTraceEventLayout;
import org.eclipse.tracecompass.incubator.rocm.core.exatracer.trace.RocmExatracerTraceEventLayout;
import org.eclipse.tracecompass.incubator.rocm.core.trace.RocmTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class RocmExatracerTrace
extends RocmTrace
implements IGpuTrace {
    private static final int CONFIDENCE = 101;
    private static LinuxPidAspect fVpidAspect = new LinuxPidAspect(){

        public @Nullable Integer resolve(ITmfEvent event) {
            Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{"context._vpid"});
            if (fieldValue != null) {
                return fieldValue.intValue();
            }
            return null;
        }
    };
    private static LinuxTidAspect fVtidAspect = new LinuxTidAspect(){

        public @Nullable Integer resolve(ITmfEvent event) {
            Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{"context._vtid"});
            if (fieldValue != null) {
                return fieldValue.intValue();
            }
            fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{RocmExatracerTraceEventLayout.getInstance().fieldThreadId()});
            if (fieldValue != null) {
                return fieldValue.intValue();
            }
            return null;
        }
    };

    public @Nullable IStatus validate(@Nullable IProject project, @Nullable String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Collection eventNames = ((CtfTraceValidationStatus)status).getEventNames();
            if (eventNames.stream().noneMatch(event -> event.startsWith("hsa")) && eventNames.stream().noneMatch(event -> event.startsWith("hip"))) {
                return new Status(4, "org.eclipse.tracecompass.incubator.rocm.core", "This trace was not recognized as a ROCm trace.");
            }
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("tracer_name");
            if (domain == null || !domain.equals("\"lttng-ust\"")) {
                return new Status(4, "org.eclipse.tracecompass.incubator.rocm.core", "This trace was not recognized as a ROCm trace.");
            }
            return new TraceValidationStatus(101, "org.eclipse.tracecompass.incubator.rocm.core");
        }
        return status;
    }

    @Override
    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        Iterable<ITmfEventAspect<?>> oldAspects = super.getEventAspects();
        ArrayList aspects = new ArrayList();
        for (ITmfEventAspect<?> aspect : oldAspects) {
            aspects.add(aspect);
        }
        aspects.add((ITmfEventAspect<?>)fVpidAspect);
        aspects.add((ITmfEventAspect<?>)fVtidAspect);
        return aspects;
    }

    public @NonNull IGpuTraceEventLayout getGpuTraceEventLayout() {
        return RocmExatracerTraceEventLayout.getInstance();
    }
}

