/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FunctionTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalFunctionBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class FieldReference
extends Reference
implements InvocationSite,
IFieldReference {
    public Expression receiver;
    public char[] token;
    public FieldBinding binding;
    public TypeBinding typeBinding;
    public long nameSourcePosition;
    public TypeBinding receiverType;

    public FieldReference(char[] source, long pos) {
        this.token = source;
        this.nameSourcePosition = pos;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)(pos & 0xFFFFFFFFL);
        this.bits |= 1;
    }

    @Override
    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        if (this.receiver instanceof SingleNameReference && ((SingleNameReference)this.receiver).binding instanceof LocalVariableBinding) {
            flowInfo.markAsDefinitelyNonNull((LocalVariableBinding)((SingleNameReference)this.receiver).binding);
            flowInfo.markAsDefinitelyAssigned((LocalVariableBinding)((SingleNameReference)this.receiver).binding);
        }
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo, this.binding == null || !this.binding.isStatic()).unconditionalInits();
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        return flowInfo;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        boolean nonStatic = this.binding == null || !this.binding.isStatic();
        this.receiver.analyseCode(currentScope, flowContext, flowInfo, nonStatic);
        if (nonStatic) {
            this.receiver.checkNPE(currentScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public FieldBinding fieldBinding() {
        return this.binding;
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    @Override
    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    @Override
    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    @Override
    public Constant optimizedBooleanConstant() {
        return Constant.NotAConstant;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.receiver.printExpression(0, output).append('.').append(this.token);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        return this.resolveType(scope, false, null);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope, boolean define, TypeBinding useType) {
        Binding alternateBinding;
        boolean receiverIsType;
        char[] possibleTypeName;
        if (this.isPrototype()) {
            this.receiverType = this.receiver.resolveType(scope);
            if (this.receiverType == null) {
                this.constant = Constant.NotAConstant;
                return null;
            }
            possibleTypeName = Util.getTypeName(this.receiver);
            TypeBinding typeBinding = scope.getJavaLangObject();
            if (possibleTypeName != null) {
                Binding possibleTypeBinding = scope.getBinding(possibleTypeName, 4, (InvocationSite)this, true);
                if (possibleTypeBinding.isValidBinding()) {
                    typeBinding = (TypeBinding)possibleTypeBinding;
                }
                char[] fieldname = new char[]{'p', 'r', 'o', 't', 'o', 't', 'y', 'p', 'e'};
                this.binding = scope.getJavaLangObject().getField(fieldname, true);
                this.constant = Constant.NotAConstant;
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
        }
        possibleTypeName = Util.getTypeName(this);
        Binding possibleTypeBinding = null;
        if (possibleTypeName != null) {
            possibleTypeBinding = scope.getBinding(possibleTypeName, 4, (InvocationSite)this, true);
        }
        if (possibleTypeBinding != null && possibleTypeBinding.isValidBinding() && (TypeBinding)possibleTypeBinding != scope.getJavaLangObject()) {
            this.typeBinding = (TypeBinding)possibleTypeBinding;
            this.constant = Constant.NotAConstant;
            this.bits |= 4;
            return this.typeBinding;
        }
        this.receiverType = this.receiver.resolveType(scope);
        if (this.receiverType == null || this.receiverType == scope.getJavaLangObject()) {
            if (possibleTypeBinding != null && possibleTypeBinding.isValidBinding()) {
                this.typeBinding = (TypeBinding)possibleTypeBinding;
                this.bits |= 4;
                return this.typeBinding;
            }
            this.binding = new ProblemFieldBinding(null, this.token, 1);
            this.constant = Constant.NotAConstant;
            this.resolvedType = TypeBinding.ANY;
            return null;
        }
        if (this.receiverType.id == 13) {
            this.constant = Constant.NotAConstant;
            this.binding = new ProblemFieldBinding(null, this.token, 1);
            this.resolvedType = TypeBinding.ANY;
            return this.resolvedType;
        }
        Binding memberBinding = scope.getFieldOrMethod(this.receiverType, this.token, this);
        boolean bl = receiverIsType = (this.receiver instanceof NameReference || this.receiver instanceof FieldReference || this.receiver instanceof ThisReference) && (this.receiver.bits & 4) != 0;
        if (!memberBinding.isValidBinding() && this.receiverType != null && this.receiverType.isFunctionType() && (alternateBinding = this.receiver.alternateBinding()) instanceof TypeBinding) {
            this.receiverType = (TypeBinding)alternateBinding;
            memberBinding = scope.getFieldOrMethod(this.receiverType, this.token, this);
            receiverIsType = true;
        }
        this.constant = Constant.NotAConstant;
        if (memberBinding instanceof FieldBinding) {
            this.binding = (FieldBinding)memberBinding;
            FieldBinding fieldBinding = this.binding;
            if (!fieldBinding.isValidBinding()) {
                this.binding = fieldBinding;
                this.resolvedType = TypeBinding.ANY;
                if (!define) {
                    this.constant = Constant.NotAConstant;
                    scope.problemReporter().invalidField(this, this.receiverType);
                    return null;
                }
            }
            if (this.isFieldUseDeprecated(fieldBinding, scope, (this.bits & 0x2000) != 0)) {
                scope.problemReporter().deprecatedField(fieldBinding, this);
            }
            boolean isImplicitThisRcv = this.receiver.isImplicitThis();
            this.constant = Constant.NotAConstant;
            if (fieldBinding.isStatic()) {
                if (!isImplicitThisRcv && !receiverIsType) {
                    scope.problemReporter().nonStaticAccessToStaticField(this, fieldBinding);
                }
                if (!isImplicitThisRcv && fieldBinding.declaringClass != this.receiverType && fieldBinding.declaringClass.canBeSeenBy(scope)) {
                    scope.problemReporter().indirectAccessToStaticField(this, fieldBinding);
                }
            } else if (receiverIsType) {
                scope.problemReporter().staticFieldAccessToNonStaticVariable(this, fieldBinding);
            }
            if (useType != null && !fieldBinding.isValidBinding()) {
                fieldBinding = new FieldBinding(fieldBinding, fieldBinding.declaringClass);
                if (fieldBinding.declaringClass instanceof SourceTypeBinding) {
                    ((SourceTypeBinding)fieldBinding.declaringClass).addField(fieldBinding);
                }
                this.binding = fieldBinding;
            }
            if (useType != null) {
                MethodBinding[] funcBindings;
                SourceTypeBinding declaringBinding;
                InferredMethod dupMeth;
                fieldBinding.type = useType;
                if (useType.isFunctionType() && fieldBinding.declaringClass instanceof SourceTypeBinding && (dupMeth = (declaringBinding = (SourceTypeBinding)fieldBinding.declaringClass).getInferredType().findMethod(this.getToken(), null)) == null && ((funcBindings = declaringBinding.getMethods(this.getToken())) == null || funcBindings.length == 0)) {
                    MethodBinding methBinding = new MethodBinding(((FunctionTypeBinding)useType).functionBinding, fieldBinding.declaringClass);
                    methBinding.selector = fieldBinding.name;
                    if (methBinding.declaringClass instanceof SourceTypeBinding) {
                        ((SourceTypeBinding)methBinding.declaringClass).addMethod(methBinding);
                    }
                }
            }
            this.resolvedType = fieldBinding.type;
            return this.resolvedType;
        }
        if (memberBinding instanceof MethodBinding) {
            MethodBinding methodBinding = (MethodBinding)memberBinding;
            if (!methodBinding.isStatic() || memberBinding instanceof LocalFunctionBinding) {
                if (receiverIsType && methodBinding.isValidBinding() && !methodBinding.isConstructor() && (this.receiverType == null || !this.receiverType.isAnonymousType())) {
                    scope.problemReporter().mustUseAStaticMethod(this, methodBinding);
                }
            } else if (!receiverIsType && methodBinding.isValidBinding()) {
                scope.problemReporter().nonStaticAccessToStaticMethod(this, methodBinding);
            }
            this.resolvedType = methodBinding.functionTypeBinding;
            this.binding = new FieldBinding(((MethodBinding)memberBinding).selector, this.receiverType, ((MethodBinding)memberBinding).modifiers, methodBinding.declaringClass);
            if (memberBinding.isValidBinding()) {
                return this.resolvedType;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    @Override
    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    @Override
    public void setFieldIndex(int index) {
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public boolean isPrototype() {
        return CharOperation.equals(TypeConstants.PROTOTYPE, this.token);
    }

    @Override
    public TypeBinding resolveForAllocation(BlockScope scope, ASTNode location) {
        Object qualifiedName = this.asQualifiedName();
        Binding typeBinding = null;
        if (qualifiedName != null) {
            typeBinding = scope.getType(CharOperation.concatWith(qualifiedName, '.'));
        }
        if (typeBinding == null || !typeBinding.isValidBinding()) {
            this.receiverType = this.receiver.resolveType(scope);
            if (this.receiverType == null) {
                this.binding = new ProblemFieldBinding(null, this.token, 1);
                this.constant = Constant.NotAConstant;
                this.resolvedType = TypeBinding.ANY;
                return null;
            }
            Binding memberBinding = scope.getFieldOrMethod(this.receiverType, this.token, this);
            if (memberBinding instanceof MethodBinding && memberBinding.isValidBinding()) {
                this.resolvedType = ((MethodBinding)memberBinding).allocationType;
                this.binding = new ProblemFieldBinding(null, this.token, 1);
                if (memberBinding.isValidBinding()) {
                    return this.resolvedType;
                }
            }
        }
        if (typeBinding == null) {
            if (qualifiedName == null) {
                qualifiedName = new char[][]{this.token};
            }
            typeBinding = new ProblemReferenceBinding((char[][])qualifiedName, null, 1);
        }
        return typeBinding;
    }

    @Override
    public int getASTType() {
        return 37;
    }

    public char[][] asQualifiedName() {
        ArrayList<char[]> list = new ArrayList<char[]>();
        list.add(this.token);
        FieldReference fieldReference = this;
        while (fieldReference != null) {
            if (fieldReference.receiver instanceof SingleNameReference) {
                list.add(0, ((SingleNameReference)fieldReference.receiver).token);
                fieldReference = null;
                continue;
            }
            if (fieldReference.receiver instanceof FieldReference) {
                fieldReference = (FieldReference)fieldReference.receiver;
                list.add(0, fieldReference.token);
                continue;
            }
            if (fieldReference.receiver instanceof ThisReference) {
                InferredType type = ((ThisReference)fieldReference.receiver).getInferredType();
                if (type == null) {
                    return null;
                }
                list.add(0, type.getName());
                fieldReference = null;
                continue;
            }
            return null;
        }
        return (char[][])list.toArray((T[])new char[list.size()][]);
    }

    @Override
    public IExpression getReceiver() {
        return this.receiver;
    }

    @Override
    public char[] getToken() {
        return this.token;
    }

    @Override
    public boolean isTypeReference() {
        return (this.bits & 4) == 4;
    }
}

