/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.IVirtualMachineEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SchedSwitchEventHandler
implements IVirtualMachineEventHandler {
    private Map<IKernelAnalysisEventLayout, Set<String>> fRequiredEvents = new HashMap<IKernelAnalysisEventLayout, Set<String>>();

    @Override
    public Set<String> getRequiredEvents(IKernelAnalysisEventLayout layout) {
        Set<String> events = this.fRequiredEvents.get(layout);
        if (events == null) {
            events = new HashSet<String>();
            events.add(layout.eventSchedSwitch());
            this.fRequiredEvents.put(layout, events);
        }
        return events;
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event, IVirtualEnvironmentModel virtEnv, IKernelAnalysisEventLayout eventLayout) {
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().toNanos();
        Long prevTid = (Long)content.getFieldValue(Long.class, new String[]{eventLayout.fieldPrevTid()});
        Long nextTid = (Long)content.getFieldValue(Long.class, new String[]{eventLayout.fieldNextTid()});
        VirtualMachine currentMachine = virtEnv.getCurrentMachine(event);
        if (currentMachine.isGuest() && nextTid != null) {
            SchedSwitchEventHandler.updateGuestStatus(ss, event, ts, currentMachine, nextTid);
        }
        if (currentMachine.isHost() && prevTid != null) {
            SchedSwitchEventHandler.updatePreviousHostStatus(ss, event, ts, currentMachine, prevTid, virtEnv);
        }
        if (currentMachine.isHost() && nextTid != null) {
            SchedSwitchEventHandler.updateNextHostStatus(ss, event, ts, currentMachine, nextTid, virtEnv);
        }
    }

    private static void updateNextHostStatus(ITmfStateSystemBuilder ss, ITmfEvent event, long ts, VirtualMachine currentMachine, Long nextTid, IVirtualEnvironmentModel virtEnv) {
        HostThread ht = new HostThread(currentMachine.getHostId(), Integer.valueOf(nextTid.intValue()));
        VirtualCPU vcpu = virtEnv.getVirtualCpu(event, ht);
        if (vcpu == null) {
            return;
        }
        VirtualMachine vm = vcpu.getVm();
        int curStatusQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Virtual Machines", vm.getHostId(), vcpu.getCpuId().toString(), "Status"});
        int prevStatus = Math.max(0, ss.queryOngoingState(curStatusQuark).unboxInt());
        int value = prevStatus & 0xFFFFFEFF;
        ss.modifyAttribute(ts, (Object)value, curStatusQuark);
    }

    private static void updatePreviousHostStatus(ITmfStateSystemBuilder ss, ITmfEvent event, long ts, VirtualMachine currentMachine, Long prevTid, IVirtualEnvironmentModel virtEnv) {
        HostThread ht = new HostThread(currentMachine.getHostId(), Integer.valueOf(prevTid.intValue()));
        VirtualCPU vcpu = virtEnv.getVirtualCpu(event, ht);
        if (vcpu == null) {
            return;
        }
        VirtualMachine vm = vcpu.getVm();
        int curStatusQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Virtual Machines", vm.getHostId(), vcpu.getCpuId().toString(), "Status"});
        int prevStatus = Math.max(0, ss.queryOngoingState(curStatusQuark).unboxInt());
        int value = prevStatus | 0x100;
        ss.modifyAttribute(ts, (Object)value, curStatusQuark);
    }

    private static void updateGuestStatus(ITmfStateSystemBuilder ss, ITmfEvent event, long ts, VirtualMachine currentMachine, Long nextTid) {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        int curStatusQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Virtual Machines", currentMachine.getHostId(), cpu.toString(), "Status"});
        int currentStatus = ss.queryOngoingState(curStatusQuark).unboxInt();
        int curVmStatus = currentStatus & 0x180;
        int value = nextTid > 0L ? 2 | curVmStatus : 1 | curVmStatus;
        ss.modifyAttribute(ts, (Object)value, curStatusQuark);
    }
}

