/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.CompilationUnitEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResultRequestor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;

public class NLSSearchQuery
implements ISearchQuery {
    private NLSSearchResult fResult;
    private IJavaScriptElement[] fWrapperClass;
    private IFile[] fPropertiesFile;
    private IJavaScriptSearchScope fScope;
    private String fScopeDescription;

    public NLSSearchQuery(IJavaScriptElement[] wrapperClass, IFile[] propertiesFile, IJavaScriptSearchScope scope, String scopeDescription) {
        this.fWrapperClass = wrapperClass;
        this.fPropertiesFile = propertiesFile;
        this.fScope = scope;
        this.fScopeDescription = scopeDescription;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("", 5 * this.fWrapperClass.length);
        try {
            AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
            textResult.removeAll();
            AppearanceAwareLabelProvider labelProvider = new AppearanceAwareLabelProvider(4471364126976L, 0);
            int i = 0;
            while (i < this.fWrapperClass.length) {
                IJavaScriptElement wrapperClass = this.fWrapperClass[i];
                IFile propertieFile = this.fPropertiesFile[i];
                if (!wrapperClass.exists()) {
                    IStatus iStatus = JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_wrapperNotExists, wrapperClass.getElementName()), null);
                    return iStatus;
                }
                if (!wrapperClass.exists()) {
                    IStatus iStatus = JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_propertiesNotExists, propertieFile.getName()), null);
                    return iStatus;
                }
                SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)wrapperClass, (int)2, (int)24);
                SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                NLSSearchResultRequestor requestor = new NLSSearchResultRequestor(propertieFile, this.fResult);
                try {
                    SearchEngine engine = new SearchEngine();
                    engine.search(pattern, participants, this.fScope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                    requestor.reportUnusedPropertyNames((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IJavaScriptUnit compilationUnit = ((IType)wrapperClass).getJavaScriptUnit();
                    CompilationUnitEntry groupElement = new CompilationUnitEntry(Messages.format(NLSSearchMessages.NLSSearchResultCollector_unusedKeys, labelProvider.getText(compilationUnit)), compilationUnit);
                    boolean hasUnusedPropertie = false;
                    IField[] fields = ((IType)wrapperClass).getFields();
                    int j = 0;
                    while (j < fields.length) {
                        ISourceRange sourceRange;
                        IField field = fields[j];
                        if (this.isNLSField(field) && (sourceRange = field.getSourceRange()) != null) {
                            String fieldName = field.getElementName();
                            if (!requestor.hasPropertyKey(fieldName)) {
                                this.fResult.addMatch(new Match((Object)compilationUnit, sourceRange.getOffset(), sourceRange.getLength()));
                            }
                            if (!requestor.isUsedPropertyKey(fieldName)) {
                                hasUnusedPropertie = true;
                                this.fResult.addMatch(new Match((Object)groupElement, sourceRange.getOffset(), sourceRange.getLength()));
                            }
                        }
                        ++j;
                    }
                    if (hasUnusedPropertie) {
                        this.fResult.addCompilationUnitGroup(groupElement);
                    }
                }
                catch (CoreException e) {
                    JavaScriptPlugin.log(e);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private boolean isNLSField(IField field) throws JavaScriptModelException {
        int flags = field.getFlags();
        if (!Flags.isPublic((int)flags)) {
            return false;
        }
        if (!Flags.isStatic((int)flags)) {
            return false;
        }
        String fieldName = field.getElementName();
        if ("BUNDLE_NAME".equals(fieldName)) {
            return false;
        }
        return !"RESOURCE_BUNDLE".equals(fieldName);
    }

    public String getLabel() {
        return NLSSearchMessages.NLSSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        if (this.fWrapperClass.length == 1) {
            if (nMatches == 1) {
                Object[] args = new String[]{this.fWrapperClass[0].getElementName(), this.fScopeDescription};
                return Messages.format(NLSSearchMessages.SearchOperation_singularLabelPostfix, args);
            }
            Object[] args = new String[]{this.fWrapperClass[0].getElementName(), String.valueOf(nMatches), this.fScopeDescription};
            return Messages.format(NLSSearchMessages.SearchOperation_pluralLabelPatternPostfix, args);
        }
        if (nMatches == 1) {
            return Messages.format(NLSSearchMessages.NLSSearchQuery_oneProblemInScope_description, this.fScopeDescription);
        }
        return Messages.format(NLSSearchMessages.NLSSearchQuery_xProblemsInScope_description, new Object[]{String.valueOf(nMatches), this.fScopeDescription});
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new NLSSearchResult(this);
        }
        return this.fResult;
    }
}

