/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModelType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2CallbackTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2NodeTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2PubTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2TakeTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackPublicationInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2MessageTransportInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2TakeInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2TimerCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ClientObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ServiceObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Ros2MessagesDataProvider
extends AbstractTimeGraphDataProvider<Ros2MessagesAnalysis, TimeGraphEntryModel> {
    public static final String SUFFIX = ".dataprovider";
    private Map<@NonNull Ros2ObjectHandle, Long> fHandleToIdMap = Maps.newHashMap();
    private final ITmfStateSystem fObjectsSs;

    public Ros2MessagesDataProvider(@NonNull ITmfTrace trace, @NonNull Ros2MessagesAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
        this.fObjectsSs = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)Ros2ObjectsAnalysis.getFullAnalysisId());
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        return new TmfModelResponse(this.getArrows(filter.getStart(), filter.getEnd()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable List<@NonNull ITimeGraphArrow> getArrows(long startTime, long endTime) {
        ITmfStateSystem messagesSs = ((Ros2MessagesAnalysis)this.getAnalysisModule()).getStateSystem();
        if (messagesSs == null) {
            return null;
        }
        @NonNull ArrayList arrows = Lists.newArrayList();
        Iterator<@NonNull T> filteredTransportLinks = Ros2MessagesUtil.getTransportInstances(messagesSs, startTime, endTime).iterator();
        while (filteredTransportLinks.hasNext()) {
            Ros2MessageTransportInstance transportInstance = (Ros2MessageTransportInstance)((Object)filteredTransportLinks.next());
            Long sourceId = this.fHandleToIdMap.get((Object)transportInstance.getPublisherHandle());
            Long destinationId = this.fHandleToIdMap.get((Object)transportInstance.getSubscriptionHandle());
            if (sourceId == null || destinationId == null) continue;
            long time = transportInstance.getSourceTimestamp();
            long duration = transportInstance.getDestinationTimestamp() - transportInstance.getSourceTimestamp();
            arrows.add(new TimeGraphArrow(sourceId.longValue(), destinationId.longValue(), time, duration, ArrowType.TRANSPORT.id));
        }
        Iterator<@NonNull T> filteredCallbackPubLinks = Ros2MessagesUtil.getCallbackPublicationInstances(messagesSs, startTime, endTime).iterator();
        while (filteredCallbackPubLinks.hasNext()) {
            Ros2CallbackPublicationInstance callbackPublicationInstance = (Ros2CallbackPublicationInstance)((Object)filteredCallbackPubLinks.next());
            Long sourceId = this.fHandleToIdMap.get((Object)callbackPublicationInstance.getCallbackOwnerHandle());
            Long destinationId = this.fHandleToIdMap.get((Object)callbackPublicationInstance.getPublisherHandle());
            if (sourceId == null || destinationId == null) continue;
            long time = callbackPublicationInstance.getPublicationTimestamp();
            long duration = 0L;
            arrows.add(new TimeGraphArrow(sourceId.longValue(), destinationId.longValue(), time, duration, ArrowType.CALLBACK_PUB.id));
        }
        return arrows;
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return Ros2MessagesDataProvider.getFullDataProviderId();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable TimeGraphModel getRowModel(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return null;
        }
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        Ros2MessagesDataProvider.queryIntervals(ss, (TreeMultimap<Integer, ITmfStateInterval>)intervals, entries, filter, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return new TimeGraphModel(Collections.emptyList());
        }
        Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = this.getPredicates(parameters);
        ArrayList<@NonNull ITimeGraphRowModel> rows = new ArrayList<ITimeGraphRowModel>();
        for (Map.Entry<Long, Integer> entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            this.addRows(ss, rows, entry, (TreeMultimap<Integer, ITmfStateInterval>)intervals, predicates, monitor);
        }
        return new TimeGraphModel(rows);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void queryIntervals(@NonNull ITmfStateSystem ss, TreeMultimap<Integer, ITmfStateInterval> intervals, Map<@NonNull Long, @NonNull Integer> entries, @NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        @NonNull Collection times = Ros2MessagesDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        Collection<Integer> valuesNull = entries.values();
        Collection timesNull = times;
        for (ITmfStateInterval interval : ss.query2D(valuesNull, timesNull)) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> getPredicates(@NonNull Map<@NonNull String, @NonNull Object> parameters) {
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        return predicates;
    }

    private void addRows(@NonNull ITmfStateSystem ss, List<@NonNull ITimeGraphRowModel> rows, Map.Entry<@NonNull Long, @NonNull Integer> entry, TreeMultimap<Integer, ITmfStateInterval> intervals, @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        int clientSendQuark;
        String grandParentName;
        ArrayList<@NonNull ITimeGraphState> eventList = new ArrayList<ITimeGraphState>();
        for (ITmfStateInterval interval : intervals.get((Object)entry.getValue())) {
            this.addRow(entry, predicates, monitor, eventList, interval);
        }
        int quark = Objects.requireNonNull(entry.getValue());
        String name = ss.getAttributeName(quark);
        int parentQuark = ss.getParentAttributeQuark(quark);
        int grandParentQuark = ss.getParentAttributeQuark(parentQuark);
        String string = grandParentName = grandParentQuark != -1 ? ss.getAttributeName(grandParentQuark) : "";
        if (name.equals(Ros2MessagesUtil.ClientServiceInstanceType.TAKE.toString()) && (grandParentName.equals("Clients") || grandParentName.equals("Services")) && -2 != (clientSendQuark = ss.optQuarkRelative(parentQuark, new String[]{Ros2MessagesUtil.ClientServiceInstanceType.SEND.toString()}))) {
            for (ITmfStateInterval interval : ss.query2D(Collections.singleton(clientSendQuark), ss.getStartTime(), ss.getCurrentEndTime())) {
                this.addRow(entry, predicates, monitor, eventList, interval);
            }
        }
        rows.add((ITimeGraphRowModel)new TimeGraphRowModel(entry.getKey().longValue(), eventList));
    }

    private void addRow(Map.Entry<@NonNull Long, @NonNull Integer> entry, @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates, @Nullable IProgressMonitor monitor, @NonNull List<@NonNull ITimeGraphState> eventList, ITmfStateInterval interval) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        Object valObject = interval.getValue();
        if (valObject instanceof Ros2NodeObject) {
            Ros2NodeObject nodeObject = (Ros2NodeObject)((Object)valObject);
            Ros2NodeTimeGraphState nodeState = new Ros2NodeTimeGraphState(startTime, duration, nodeObject);
            this.applyFilterAndAddState(eventList, (ITimeGraphState)nodeState, entry.getKey(), predicates, monitor);
        } else if (valObject instanceof Ros2PubInstance) {
            Ros2PubInstance pubInstance = (Ros2PubInstance)((Object)valObject);
            Ros2PubTimeGraphState pubState = new Ros2PubTimeGraphState(startTime, duration, pubInstance);
            this.applyFilterAndAddState(eventList, (ITimeGraphState)pubState, entry.getKey(), predicates, monitor);
            this.fHandleToIdMap.put(pubInstance.getPublisherHandle(), entry.getKey());
        } else if (valObject instanceof Ros2SubCallbackInstance) {
            Ros2SubCallbackInstance subCallbackInstance = (Ros2SubCallbackInstance)((Object)valObject);
            Ros2TakeInstance takeInstance = subCallbackInstance.getTakeInstance();
            Ros2TakeTimeGraphState takeState = new Ros2TakeTimeGraphState(takeInstance);
            this.applyFilterAndAddState(eventList, (ITimeGraphState)takeState, entry.getKey(), predicates, monitor);
            Ros2CallbackInstance callbackInstance = subCallbackInstance.getCallbackInstance();
            Ros2CallbackTimeGraphState callbackState = new Ros2CallbackTimeGraphState(callbackInstance);
            this.applyFilterAndAddState(eventList, (ITimeGraphState)callbackState, entry.getKey(), predicates, monitor);
            this.fHandleToIdMap.put(takeInstance.getSubscriptionHandle(), entry.getKey());
        } else if (valObject instanceof Ros2TakeInstance) {
            Ros2TakeInstance takeInstance = (Ros2TakeInstance)((Object)valObject);
            Ros2TakeTimeGraphState takeState = new Ros2TakeTimeGraphState(takeInstance);
            this.applyFilterAndAddState(eventList, (ITimeGraphState)takeState, entry.getKey(), predicates, monitor);
            this.fHandleToIdMap.put(takeInstance.getSubscriptionHandle(), entry.getKey());
        } else if (valObject instanceof Ros2TimerCallbackInstance) {
            Ros2TimerCallbackInstance timerCallbackInstance = (Ros2TimerCallbackInstance)((Object)valObject);
            Ros2CallbackInstance callbackInstance = timerCallbackInstance.getCallbackInstance();
            Ros2CallbackTimeGraphState callbackState = new Ros2CallbackTimeGraphState(callbackInstance);
            this.applyFilterAndAddState(eventList, (ITimeGraphState)callbackState, entry.getKey(), predicates, monitor);
            this.fHandleToIdMap.put(timerCallbackInstance.getTimerHandle(), entry.getKey());
        }
    }

    protected boolean isCacheable() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull TmfTreeModel<@NonNull TimeGraphEntryModel> getTree(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        long parentId = this.getId(-1);
        builder.add((Object)new TimeGraphEntryModel(parentId, -1L, String.valueOf(this.getTrace().getName()), ss.getStartTime(), ss.getCurrentEndTime()));
        this.addChildren(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, -1, parentId);
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private void addChildren(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            this.addChildrenEntryModel(ss, builder, quark, parentId, child);
        }
    }

    private void addChildrenEntryModel(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId, Integer child) {
        String grandParentName;
        long childId = this.getId(child);
        String name = ss.getAttributeName(child.intValue());
        String parentName = quark != -1 ? ss.getAttributeName(quark) : "";
        int grandParentQuark = ss.getParentAttributeQuark(quark);
        String string = grandParentName = grandParentQuark != -1 ? ss.getAttributeName(grandParentQuark) : "";
        if (-1 == quark) {
            if (this.addEntryModel(ss, builder, childId, parentId, child, Ros2ObjectTimeGraphEntryModelType.TRACE)) {
                this.addChildren(ss, builder, child, childId);
            }
        } else if (parentName.equals("Nodes")) {
            if (this.addEntryModel(ss, builder, childId, parentId, child, Ros2ObjectTimeGraphEntryModelType.NODE)) {
                this.addChildren(ss, builder, child, childId);
            }
        } else if (parentName.equals("Publishers")) {
            this.addEntryModel(ss, builder, childId, parentId, child, Ros2ObjectTimeGraphEntryModelType.PUBLISHER);
        } else if (parentName.equals("Subscriptions")) {
            this.addEntryModel(ss, builder, childId, parentId, child, Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION);
        } else if (name.equals(Ros2MessagesUtil.ClientServiceInstanceType.TAKE.toString())) {
            if (grandParentName.equals("Clients")) {
                this.addEntryModel(ss, builder, childId, parentId, child, Ros2ObjectTimeGraphEntryModelType.CLIENT);
            } else if (grandParentName.equals("Services")) {
                this.addEntryModel(ss, builder, childId, parentId, child, Ros2ObjectTimeGraphEntryModelType.SERVICE);
            }
        } else if (parentName.equals("Timers")) {
            this.addEntryModel(ss, builder, childId, parentId, child, Ros2ObjectTimeGraphEntryModelType.TIMER);
        } else if (name.equals("Nodes") || name.equals("Publishers") || name.equals("Subscriptions") || name.equals("Clients") || parentName.equals("Clients") || name.equals("Services") || parentName.equals("Services") || name.equals(Ros2MessagesUtil.ClientServiceInstanceType.SEND.toString()) || name.equals("Timers")) {
            this.addChildren(ss, builder, child, parentId);
        } else {
            builder.add((Object)new TimeGraphEntryModel(childId, parentId, name, ss.getStartTime(), ss.getCurrentEndTime(), true));
            this.addChildren(ss, builder, child, childId);
        }
    }

    private boolean addEntryModel(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, long id, long parentId, int quark, Ros2ObjectTimeGraphEntryModelType type) {
        switch (type) {
            case TRACE: {
                @Nullable Ros2NodeObject traceNodeObject = Ros2MessagesDataProvider.getNodeFromTrace(ss, quark);
                if (traceNodeObject == null) break;
                builder.add((Object)new Ros2ObjectTimeGraphEntryModel(id, parentId, ss.getStartTime(), ss.getCurrentEndTime(), Ros2ObjectTimeGraphEntryModelType.TRACE, (Object)traceNodeObject));
                return true;
            }
            case NODE: {
                @Nullable Ros2NodeObject nodeObject = Ros2MessagesDataProvider.getNodeObject(ss, quark);
                if (nodeObject == null) break;
                builder.add((Object)new Ros2ObjectTimeGraphEntryModel(id, parentId, ss.getStartTime(), ss.getCurrentEndTime(), Ros2ObjectTimeGraphEntryModelType.NODE, (Object)nodeObject));
                return true;
            }
            case PUBLISHER: {
                @Nullable Ros2PublisherObject publisherObject = this.getPublisherObject(ss, quark);
                if (publisherObject == null) break;
                builder.add((Object)new Ros2ObjectTimeGraphEntryModel(id, parentId, ss.getStartTime(), ss.getCurrentEndTime(), Ros2ObjectTimeGraphEntryModelType.PUBLISHER, (Object)publisherObject));
                return true;
            }
            case SUBSCRIPTION: {
                @Nullable Ros2SubscriptionObject subscriptionObject = this.getSubscriptionObject(ss, quark);
                if (subscriptionObject == null) break;
                builder.add((Object)new Ros2ObjectTimeGraphEntryModel(id, parentId, ss.getStartTime(), ss.getCurrentEndTime(), Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION, (Object)subscriptionObject));
                return true;
            }
            case CLIENT: {
                @Nullable Ros2ClientObject clientObject = this.getClientObject(ss, quark);
                if (clientObject == null) break;
                builder.add((Object)new Ros2ObjectTimeGraphEntryModel(id, parentId, ss.getStartTime(), ss.getCurrentEndTime(), Ros2ObjectTimeGraphEntryModelType.CLIENT, (Object)clientObject));
                return true;
            }
            case SERVICE: {
                @Nullable Ros2ServiceObject serviceObject = this.getServiceObject(ss, quark);
                if (serviceObject == null) break;
                builder.add((Object)new Ros2ObjectTimeGraphEntryModel(id, parentId, ss.getStartTime(), ss.getCurrentEndTime(), Ros2ObjectTimeGraphEntryModelType.SERVICE, (Object)serviceObject));
                return true;
            }
            case TIMER: {
                @Nullable Ros2TimerObject timerObject = this.getTimerObject(ss, quark);
                if (timerObject == null) break;
                builder.add((Object)new Ros2ObjectTimeGraphEntryModel(id, parentId, ss.getStartTime(), ss.getCurrentEndTime(), Ros2ObjectTimeGraphEntryModelType.TIMER, (Object)timerObject));
                return true;
            }
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable Ros2NodeObject getNodeFromTrace(ITmfStateSystem ss, int traceQuark) {
        @NonNull List nodeQuarks = ss.getQuarks(traceQuark, new String[]{"Nodes", "*"});
        if (nodeQuarks.isEmpty()) {
            Activator.getInstance().logError("there should be at least one node under a trace quark");
            return null;
        }
        return Ros2MessagesDataProvider.getNodeObject(ss, (Integer)nodeQuarks.get(0));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable Ros2NodeObject getNodeObject(ITmfStateSystem ss, int quark) {
        try {
            @NonNull Iterable query2d = ss.query2D(Collections.singleton(quark), ss.getStartTime(), ss.getCurrentEndTime());
            for (ITmfStateInterval iTmfStateInterval : query2d) {
                if (iTmfStateInterval.getValue() instanceof String) {
                    return null;
                }
                @Nullable Ros2NodeObject nodeObject = (Ros2NodeObject)((Object)iTmfStateInterval.getValue());
                if (nodeObject == null) continue;
                return nodeObject;
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        Activator.getInstance().logError("could not get node object for entry model");
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Ros2PublisherObject getPublisherObject(ITmfStateSystem ss, int quark) {
        try {
            @NonNull Iterable query2d = ss.query2D(Collections.singleton(quark), ss.getStartTime(), ss.getCurrentEndTime());
            for (ITmfStateInterval iTmfStateInterval : query2d) {
                @Nullable Ros2PubInstance pubInstance = (Ros2PubInstance)((Object)iTmfStateInterval.getValue());
                if (pubInstance == null) continue;
                return Ros2ObjectsUtil.getPublisherObjectFromHandle(this.fObjectsSs, ss.getCurrentEndTime(), pubInstance.getPublisherHandle());
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        Activator.getInstance().logError("could not get publisher object for entry model");
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable Ros2SubscriptionObject getSubscriptionObject(ITmfStateSystem ss, int quark) {
        try {
            @NonNull Iterable query2d = ss.query2D(Collections.singleton(quark), ss.getStartTime(), ss.getCurrentEndTime());
            for (ITmfStateInterval iTmfStateInterval : query2d) {
                if (iTmfStateInterval.getValue() instanceof String) {
                    return null;
                }
                @Nullable Ros2SubCallbackInstance subCallbackInstance = (Ros2SubCallbackInstance)((Object)iTmfStateInterval.getValue());
                if (subCallbackInstance == null) continue;
                return Ros2ObjectsUtil.getSubscriptionObjectFromHandle(this.fObjectsSs, ss.getCurrentEndTime(), subCallbackInstance.getTakeInstance().getSubscriptionHandle());
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        Activator.getInstance().logError("could not get subscription object for entry model");
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Ros2ClientObject getClientObject(ITmfStateSystem ss, int quark) {
        try {
            @NonNull Iterable query2d = ss.query2D(Collections.singleton(quark), ss.getStartTime(), ss.getCurrentEndTime());
            for (ITmfStateInterval iTmfStateInterval : query2d) {
                Ros2TakeInstance responseTakeInstance;
                if (!(iTmfStateInterval.getValue() instanceof Ros2TakeInstance) || (responseTakeInstance = (Ros2TakeInstance)((Object)iTmfStateInterval.getValue())) == null) continue;
                return Ros2ObjectsUtil.getClientObjectFromHandle(this.fObjectsSs, ss.getCurrentEndTime(), responseTakeInstance.getSubscriptionHandle());
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        Activator.getInstance().logError("could not get client object for entry model");
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Ros2ServiceObject getServiceObject(ITmfStateSystem ss, int quark) {
        try {
            @NonNull Iterable query2d = ss.query2D(Collections.singleton(quark), ss.getStartTime(), ss.getCurrentEndTime());
            for (ITmfStateInterval iTmfStateInterval : query2d) {
                Ros2SubCallbackInstance subCallbackInstance;
                if (!(iTmfStateInterval.getValue() instanceof Ros2SubCallbackInstance) || (subCallbackInstance = (Ros2SubCallbackInstance)((Object)iTmfStateInterval.getValue())) == null) continue;
                return Ros2ObjectsUtil.getServiceObjectFromHandle(this.fObjectsSs, ss.getCurrentEndTime(), subCallbackInstance.getTakeInstance().getSubscriptionHandle());
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        Activator.getInstance().logError("could not get service object for entry model");
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Ros2TimerObject getTimerObject(ITmfStateSystem ss, int quark) {
        try {
            @NonNull Iterable query2d = ss.query2D(Collections.singleton(quark), ss.getStartTime(), ss.getCurrentEndTime());
            for (ITmfStateInterval iTmfStateInterval : query2d) {
                @Nullable Ros2TimerCallbackInstance timerCallbackInstance = (Ros2TimerCallbackInstance)((Object)iTmfStateInterval.getValue());
                if (timerCallbackInstance == null) continue;
                return Ros2ObjectsUtil.getTimerObjectFromHandle(this.fObjectsSs, ss.getCurrentEndTime(), timerCallbackInstance.getTimerHandle());
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        Activator.getInstance().logError("could not get subscription object for entry model");
        return null;
    }

    public static @NonNull String getFullDataProviderId() {
        return Ros2MessagesAnalysis.getFullAnalysisId() + SUFFIX;
    }

    public static enum ArrowType {
        TRANSPORT(1),
        CALLBACK_PUB(2),
        WAIT(3);

        private final int id;

        private ArrowType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

