/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.async.UICallbackInvocationDelegate;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.terminals.actions.PinTerminalAction;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.interfaces.IMementoHandler;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderToolbarHandler;
import org.eclipse.tcf.te.ui.terminals.view.TerminalsView;
import org.eclipse.ui.IMemento;

public class TerminalsViewMementoHandler {
    private final List<CTabItem> saveables = new ArrayList<CTabItem>();

    public void setSaveables(List<CTabItem> saveables) {
        Assert.isNotNull(saveables);
        this.saveables.clear();
        this.saveables.addAll(saveables);
    }

    public void saveState(TerminalsView view, IMemento memento) {
        Assert.isNotNull((Object)view);
        Assert.isNotNull((Object)memento);
        memento = memento.createChild("terminalConnections");
        Assert.isNotNull((Object)memento);
        memento.putString("id", view.getViewSite().getId());
        memento.putString("secondaryId", view.getViewSite().getSecondaryId());
        memento.putBoolean("pinned", view.isPinned());
        for (CTabItem item : this.saveables) {
            String connectorTypeId;
            IMementoHandler mementoHandler;
            IPropertiesContainer properties;
            if (item.isDisposed() || (properties = (IPropertiesContainer)item.getData("properties")) == null) continue;
            String delegateId = properties.getStringProperty("delegateId");
            ILauncherDelegate delegate = delegateId != null ? LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false) : null;
            IMementoHandler iMementoHandler = mementoHandler = delegate != null ? (IMementoHandler)delegate.getAdapter(IMementoHandler.class) : null;
            if (mementoHandler == null) continue;
            IMemento connectionMemento = memento.createChild("connection");
            Assert.isNotNull((Object)connectionMemento);
            connectionMemento.putString("delegateId", delegateId);
            String terminalConnectorId = properties.getStringProperty("tm.terminal.connector.id");
            if (terminalConnectorId != null) {
                connectionMemento.putString("tm.terminal.connector.id", terminalConnectorId);
            }
            if ((connectorTypeId = properties.getStringProperty("connector.type.id")) != null) {
                connectionMemento.putString("connector.type.id", connectorTypeId);
            }
            if (properties.getProperty("terminal.forceNew") != null) {
                connectionMemento.putBoolean("terminal.forceNew", properties.getBooleanProperty("terminal.forceNew"));
            }
            mementoHandler.saveState(connectionMemento, properties);
        }
    }

    protected void restoreState(final TerminalsView view, IMemento memento) {
        Assert.isNotNull((Object)view);
        Assert.isNotNull((Object)memento);
        memento = memento.getChild("terminalConnections");
        if (memento != null) {
            IMemento[] connections;
            String id = memento.getString("id");
            String secondaryId = memento.getString("secondaryId");
            if ("null".equals(secondaryId)) {
                secondaryId = null;
            }
            final IMemento finMemento = memento;
            AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    if (finMemento.getBoolean("pinned") != null) {
                        DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PinTerminalAction action;
                                view.setPinned(finMemento.getBoolean("pinned"));
                                TabFolderToolbarHandler toolbarHandler = (TabFolderToolbarHandler)((Object)view.getAdapter(TabFolderToolbarHandler.class));
                                if (toolbarHandler != null && (action = (PinTerminalAction)((Object)toolbarHandler.getAdapter(PinTerminalAction.class))) != null) {
                                    action.setChecked(view.isPinned());
                                }
                            }
                        });
                    }
                }
            }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new UICallbackInvocationDelegate());
            IMemento[] iMementoArray = connections = memento.getChildren("connection");
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                IMementoHandler mementoHandler;
                IMemento connection = iMementoArray[n2];
                PropertiesContainer properties = new PropertiesContainer();
                properties.setProperty("id", (Object)id);
                properties.setProperty("secondaryId", (Object)secondaryId);
                properties.setProperty("delegateId", (Object)connection.getString("delegateId"));
                properties.setProperty("tm.terminal.connector.id", (Object)connection.getString("tm.terminal.connector.id"));
                properties.setProperty("connector.type.id", (Object)connection.getString("connector.type.id"));
                properties.setProperty("terminal.forceNew", (Object)connection.getBoolean("terminal.forceNew"));
                String delegateId = properties.getStringProperty("delegateId");
                ILauncherDelegate delegate = delegateId != null ? LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false) : null;
                IMementoHandler iMementoHandler = mementoHandler = delegate != null ? (IMementoHandler)delegate.getAdapter(IMementoHandler.class) : null;
                if (mementoHandler != null) {
                    mementoHandler.restoreState(connection, (IPropertiesContainer)properties);
                }
                if (delegate != null && !properties.isEmpty()) {
                    delegate.execute((IPropertiesContainer)properties, (ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector));
                }
                ++n2;
            }
            collector.initDone();
        }
    }
}

