/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.interfaces.ITerminalsView;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderManager;
import org.eclipse.tcf.te.ui.terminals.view.TerminalsView;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;

public class ConsoleManager {
    private final IPerspectiveListener perspectiveListener = new ConsoleManagerPerspectiveListener();

    public static ConsoleManager getInstance() {
        return LazyInstanceHolder.fInstance;
    }

    ConsoleManager() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(this.perspectiveListener);
        }
    }

    private final IWorkbenchPage getActiveWorkbenchPage() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return null;
    }

    public ITerminalsView findConsoleView(String id, String secondaryId) {
        IViewPart part;
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        ITerminalsView view = null;
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null && (part = this.getTerminalsViewWithSecondaryId(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView", secondaryId)) instanceof ITerminalsView) {
            view = (ITerminalsView)part;
        }
        return view;
    }

    private IViewPart getTerminalsViewWithSecondaryId(String id, String secondaryId) {
        Assert.isNotNull((Object)id);
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            String secId;
            IViewPart part;
            IViewReference ref = refs[i];
            if (ref.getId().equals(id) && (part = ref.getView(true)) instanceof ITerminalsView && ((secId = ((IViewSite)part.getSite()).getSecondaryId()) != null && secId.equals(secondaryId) || secId == null && secondaryId == null)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private IViewPart getFirstNotPinnedTerminalsView(String id) {
        Assert.isNotNull((Object)id);
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IViewPart part;
            IViewReference ref = refs[i];
            if (ref.getId().equals(id) && (part = ref.getView(true)) instanceof ITerminalsView && !((ITerminalsView)part).isPinned()) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private IViewPart getFirstTerminalsView(String id, String secondaryId, boolean useActive) {
        Assert.isNotNull((Object)id);
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            if (ref.getId().equals(id) && (secondaryId == null || secondaryId.equals(ref.getSecondaryId()))) {
                IViewPart part = ref.getView(true);
                if (useActive) {
                    if (page.isPartVisible((IWorkbenchPart)part)) {
                        return part;
                    }
                } else {
                    return part;
                }
            }
            ++i;
        }
        return null;
    }

    private String getNextTerminalSecondaryId(String id) {
        Assert.isNotNull((Object)id);
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        HashMap<String, IViewReference> terminalViews = new HashMap<String, IViewReference>();
        int maxNumber = 0;
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            if (ref.getId().equals(id)) {
                if (ref.getSecondaryId() != null) {
                    terminalViews.put(ref.getSecondaryId(), ref);
                    int scondaryIdInt = Integer.parseInt(ref.getSecondaryId());
                    if (scondaryIdInt > maxNumber) {
                        maxNumber = scondaryIdInt;
                    }
                } else {
                    terminalViews.put(Integer.toString(0), ref);
                }
            }
            ++i;
        }
        if (terminalViews.size() == 0) {
            return null;
        }
        i = 0;
        while (i < maxNumber) {
            String secondaryIdStr = Integer.toString(i);
            if (!terminalViews.keySet().contains(secondaryIdStr)) {
                return Integer.toString(i);
            }
            ++i;
        }
        return Integer.toString(i + 1);
    }

    public IViewPart showConsoleView(String id, String secondaryId) {
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null) {
            try {
                IViewPart part = page.showView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView", secondaryId, 1);
                page.bringToTop((IWorkbenchPart)part);
                return part;
            }
            catch (PartInitException e) {
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    private IViewPart bringToTop(String id, String secondaryId, boolean activate) {
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null) {
            IViewPart anyTerminal = this.getFirstTerminalsView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView", secondaryId, false);
            if (anyTerminal != null) {
                IViewPart activePart = this.getFirstTerminalsView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView", secondaryId, true);
                if (activePart == null) {
                    IViewPart notPinnedPart = this.getFirstNotPinnedTerminalsView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView");
                    if (notPinnedPart != null) {
                        if (activate) {
                            page.activate((IWorkbenchPart)notPinnedPart);
                        } else {
                            page.bringToTop((IWorkbenchPart)notPinnedPart);
                        }
                        return notPinnedPart;
                    }
                    IViewPart newPart = this.showConsoleView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView", this.getNextTerminalSecondaryId(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView"));
                    return newPart;
                }
                if (((ITerminalsView)activePart).isPinned() && secondaryId == null) {
                    IViewPart notPinnedPart = this.getFirstNotPinnedTerminalsView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView");
                    if (notPinnedPart != null) {
                        if (activate) {
                            page.activate((IWorkbenchPart)notPinnedPart);
                        } else {
                            page.bringToTop((IWorkbenchPart)notPinnedPart);
                        }
                        return notPinnedPart;
                    }
                    IViewPart newPart = this.showConsoleView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView", this.getNextTerminalSecondaryId(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView"));
                    return newPart;
                }
                return activePart;
            }
            if (activate) {
                IViewPart newPart = this.showConsoleView(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView", this.getNextTerminalSecondaryId(id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView"));
                return newPart;
            }
        }
        return null;
    }

    public CTabItem openConsole(String id, String title, String encoding, ITerminalConnector connector, Object data, Map<String, Boolean> flags) {
        return this.openConsole(id, null, title, encoding, connector, data, flags);
    }

    public CTabItem openConsole(String id, String secondaryId, String title, String encoding, ITerminalConnector connector, Object data, Map<String, Boolean> flags) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        boolean activate = flags != null && flags.containsKey("activate") ? flags.get("activate") : false;
        boolean forceNew = flags != null && flags.containsKey("terminal.forceNew") ? flags.get("terminal.forceNew") : false;
        IViewPart part = this.bringToTop(id, secondaryId, activate);
        if (!(part instanceof ITerminalsView)) {
            return null;
        }
        ITerminalsView view = (ITerminalsView)part;
        TabFolderManager manager = (TabFolderManager)((Object)view.getAdapter(TabFolderManager.class));
        if (manager == null) {
            return null;
        }
        String secId = ((IViewSite)part.getSite()).getSecondaryId();
        CTabItem item = this.findConsole(id, secId, title, connector, data);
        view.switchToTabFolderControl();
        if (item == null || forceNew) {
            if (UIPlugin.getScopedPreferences().getBoolean("terminals.removeTerminatedTerminals")) {
                manager.removeTerminatedItems();
                view.switchToTabFolderControl();
            }
            item = manager.createTabItem(title, encoding, connector, data, flags);
        }
        if (item == null) {
            return null;
        }
        manager.bringToTop(item);
        view.setFocus();
        return item;
    }

    public CTabItem findConsole(String id, String secondaryId, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        ITerminalsView view = this.findConsoleView(id, secondaryId);
        if (view == null) {
            return null;
        }
        TabFolderManager manager = (TabFolderManager)((Object)view.getAdapter(TabFolderManager.class));
        if (manager == null) {
            return null;
        }
        return manager.findTabItem(title, connector, data);
    }

    /*
     * Unable to fully structure code
     */
    public CTabItem findConsole(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        item = null;
        page = this.getActiveWorkbenchPage();
        if (page != null) {
            refs = page.getViewReferences();
            i = 0;
            while (i < refs.length) {
                ref = refs[i];
                v0 = part = ref != null ? ref.getView(false) : null;
                if (part instanceof ITerminalsView) {
                    tabFolder = (CTabFolder)part.getAdapter(CTabFolder.class);
                    if (tabFolder != null) {
                        var13_13 = candidates = tabFolder.getItems();
                        var12_12 = candidates.length;
                        var11_11 = 0;
                        while (var11_11 < var12_12) {
                            candidate = var13_13[var11_11];
                            data = candidate.getData();
                            if (data instanceof ITerminalControl && control.equals(data)) {
                                item = candidate;
                                ** break;
                            }
                            ++var11_11;
                        }
                    }
                } else if (item != null) break;
                ++i;
            }
        }
        return item;
    }

    private CTabItem findConsoleForTerminalConnector(String id, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null) {
            IViewReference[] refs = page.getViewReferences();
            int i = 0;
            while (i < refs.length) {
                CTabItem item;
                TabFolderManager manager;
                IViewPart part;
                IViewReference ref = refs[i];
                if (ref.getId().equals(id) && (part = ref.getView(true)) instanceof ITerminalsView && (manager = (TabFolderManager)((Object)part.getAdapter(TabFolderManager.class))) != null && (item = manager.findTabItem(title, connector, data)) != null) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    public void closeConsole(String id, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem console = this.findConsoleForTerminalConnector(id, title, connector, data);
        if (console != null) {
            console.dispose();
        }
    }

    public void terminateConsole(String id, String title, ITerminalConnector connector, Object data) {
        ITerminalViewControl terminal;
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem console = this.findConsoleForTerminalConnector(id, title, connector, data);
        if (console != null && !console.isDisposed() && (terminal = (ITerminalViewControl)console.getData()) != null && !terminal.isDisposed()) {
            terminal.disconnectTerminal();
        }
    }

    static class ConsoleManagerPerspectiveListener
    extends PerspectiveAdapter {
        private final List<IViewReference> references = new ArrayList<IViewReference>();

        ConsoleManagerPerspectiveListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (this.references.isEmpty()) {
                return;
            }
            ArrayList<IViewReference> oldReferences = new ArrayList<IViewReference>(this.references);
            ArrayList<IViewReference> references = new ArrayList<IViewReference>(Arrays.asList(page.getViewReferences()));
            for (IViewReference reference : oldReferences) {
                if (references.contains(reference)) continue;
                try {
                    page.showView(reference.getId(), reference.getSecondaryId(), 2);
                }
                catch (PartInitException partInitException) {}
            }
        }

        public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.references.clear();
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                IViewPart part = reference.getView(false);
                if (part instanceof TerminalsView && !this.references.contains(reference)) {
                    this.references.add(reference);
                }
                ++n2;
            }
        }
    }

    private static class LazyInstanceHolder {
        public static ConsoleManager fInstance = new ConsoleManager();

        private LazyInstanceHolder() {
        }
    }
}

