/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.core;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.IUserAuthenticator;
import org.eclipse.remote.internal.core.RemoteCorePlugin;

public abstract class AbstractRemoteConnectionManager
implements IRemoteConnectionManager {
    private static final String AUTHENTICATOR_EXTENSION_POINT_ID = "authenticator";
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String PRIORITY_ATTR = "priority";
    private final IRemoteServices fRemoteServices;
    private boolean fLoaded;
    private Constructor<?> fUserAuthenticatorConstructor;

    public AbstractRemoteConnectionManager(IRemoteServices services) {
        this.fRemoteServices = services;
    }

    protected IRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    @Override
    public IUserAuthenticator getUserAuthenticator(IRemoteConnection connection) {
        if (!this.fLoaded) {
            IExtension[] extensions;
            int currPriority = -1;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(RemoteCorePlugin.getUniqueIdentifier(), AUTHENTICATOR_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String id = ce.getAttribute(ID_ATTR);
                    if (id.equals(this.getRemoteServices().getId())) {
                        int priority = 0;
                        String priorityAttr = ce.getAttribute(PRIORITY_ATTR);
                        if (priorityAttr != null) {
                            try {
                                priority = Integer.parseInt(priorityAttr);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if (priority > currPriority) {
                            try {
                                String widgetClass = ce.getAttribute(CLASS_ATTR);
                                Class cls = Platform.getBundle((String)ce.getDeclaringExtension().getContributor().getName()).loadClass(widgetClass);
                                if (cls != null) {
                                    this.fUserAuthenticatorConstructor = cls.getConstructor(IRemoteConnection.class);
                                    currPriority = priority;
                                }
                            }
                            catch (ClassNotFoundException | NoSuchMethodException e) {
                                RemoteCorePlugin.log(e);
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            this.fLoaded = true;
        }
        if (this.fUserAuthenticatorConstructor != null) {
            try {
                return (IUserAuthenticator)this.fUserAuthenticatorConstructor.newInstance(connection);
            }
            catch (Exception e) {
                RemoteCorePlugin.log(e);
            }
        }
        return null;
    }
}

