/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.process;

import java.util.Map;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.core.terminals.TerminalServiceFactory;
import org.eclipse.tcf.te.core.terminals.interfaces.ITerminalService;
import org.eclipse.tcf.te.core.terminals.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanelContainer;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.launcher.AbstractLauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.process.ProcessSettings;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;

public class ProcessLauncherDelegate
extends AbstractLauncherDelegate {
    public boolean needsUserConfiguration() {
        return false;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return null;
    }

    public void execute(Map<String, Object> properties, ITerminalService.Done done) {
        Assert.isNotNull(properties);
        ITerminalService terminal = TerminalServiceFactory.getService();
        if (terminal != null) {
            terminal.openConsole(properties, done);
        }
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tcf.te.ui.terminals.ProcessConnector";
        }
        String image = (String)properties.get("process.path");
        String arguments = (String)properties.get("process.args");
        Process process = (Process)properties.get("process");
        PTY pty = (PTY)properties.get("pty");
        Object value = properties.get("localEcho");
        boolean localEcho = value instanceof Boolean ? (Boolean)value : false;
        String lineSeparator = (String)properties.get("lineSeparator");
        ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stdoutListeners");
        ITerminalServiceOutputStreamMonitorListener[] stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stderrListeners");
        String workingDir = (String)properties.get("process.working_dir");
        String[] envp = null;
        if (properties.containsKey("process.environment") && properties.get("process.environment") != null && properties.get("process.environment") instanceof String[]) {
            envp = (String[])properties.get("process.environment");
        }
        Assert.isTrue((image != null || process != null ? 1 : 0) != 0);
        SettingsStore store = new SettingsStore();
        ProcessSettings processSettings = new ProcessSettings();
        processSettings.setImage(image);
        processSettings.setArguments(arguments);
        processSettings.setProcess(process);
        processSettings.setPTY(pty);
        processSettings.setLocalEcho(localEcho);
        processSettings.setLineSeparator(lineSeparator);
        processSettings.setStdOutListeners(stdoutListeners);
        processSettings.setStdErrListeners(stderrListeners);
        processSettings.setWorkingDir(workingDir);
        processSettings.setEnvironment(envp);
        if (properties.containsKey("process.environment.merge")) {
            value = properties.get("process.environment.merge");
            processSettings.setMergeWithNativeEnvironment(value instanceof Boolean ? (Boolean)value : false);
        }
        processSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

