/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.internal.debug.ui.launch.ContextListControl;
import org.eclipse.tcf.internal.debug.ui.launch.ContextSelection;
import org.eclipse.tcf.internal.debug.ui.launch.PeerListControl;

public class ContextSelectionDialog
extends Dialog {
    private final boolean processes;
    private ContextSelection selection;
    private ContextListControl context_list;

    public ContextSelectionDialog(IShellProvider parentShell, boolean processes) {
        super(parentShell);
        this.processes = processes;
    }

    public void setSelection(ContextSelection selection) {
        this.selection = selection;
    }

    public ContextSelection getSelection() {
        return this.selection;
    }

    protected void configureShell(Shell shell) {
        shell.setText("Select Peer and Context");
        super.configureShell(shell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateButtonState();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        new Label(composite, 0).setText("Peers:");
        PeerListControl peerList = new PeerListControl(composite){

            @Override
            protected void onPeerSelected(PeerListControl.PeerInfo info) {
                ContextSelectionDialog.this.handlePeerSelected(info);
            }
        };
        new Label(composite, 0).setText("Contexts:");
        this.context_list = new ContextListControl(composite, this.processes);
        this.context_list.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextListControl.ContextInfo contextInfo = ContextSelectionDialog.this.context_list.findInfo((TreeItem)e.item);
                if (contextInfo != null) {
                    ContextSelectionDialog.this.handleContextSelected(contextInfo);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (ContextSelectionDialog.this.getButton(0).isEnabled()) {
                    ContextSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        if (this.selection.fPeerId != null) {
            peerList.setInitialSelection(this.selection.fPeerId);
        }
        if (this.selection.fContextFullName != null) {
            this.context_list.setInitialSelection(this.selection.fContextFullName);
        }
        return composite;
    }

    private void updateButtonState() {
        this.getButton(0).setEnabled(this.selection.fContextId != null);
    }

    protected void handleContextSelected(ContextListControl.ContextInfo info) {
        this.selection.fContextId = info.id;
        this.selection.fContextName = info.name;
        this.selection.fContextFullName = this.context_list.getFullName(info);
        this.selection.fIsAttached = info.is_attached;
        this.updateButtonState();
    }

    protected void handlePeerSelected(PeerListControl.PeerInfo info) {
        this.selection.fPeerId = info.id;
        this.context_list.setInput(info.peer);
    }
}

