/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.utils;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class CommonUtils {
    public static String getType(IPeerNode peerNode) {
        if (peerNode != null) {
            return peerNode.getPeerType();
        }
        return null;
    }

    public static String getType(IPeer peer) {
        if (peer != null) {
            return (String)peer.getAttributes().get("Type");
        }
        return null;
    }

    public static String getType(IPropertiesContainer props) {
        return props != null ? props.getStringProperty("Type") : null;
    }

    public static String getSubType(IPeerNode peerNode) {
        IPeer peer = peerNode.getPeer();
        return CommonUtils.getSubType(peer);
    }

    public static String getSubType(IPeer peer) {
        Map attrs = peer.getAttributes();
        String subType = (String)attrs.get("SubType");
        if (subType == null) {
            subType = "real";
        }
        return subType;
    }

    public static String getSubType(IPropertiesContainer props) {
        String subType = props.getStringProperty("SubType");
        if (subType == null) {
            subType = "real";
        }
        return subType;
    }

    public static String getMode(IPeerNode peerNode) {
        IPeer peer = peerNode.getPeer();
        return CommonUtils.getMode(peer);
    }

    public static String getMode(IPeer peer) {
        Map attrs = peer.getAttributes();
        String mode = (String)attrs.get("Mode");
        if (mode == null) {
            mode = "run";
        }
        return mode;
    }

    public static String getMode(IPropertiesContainer props) {
        String mode = props.getStringProperty("Mode");
        if (mode == null) {
            mode = "run";
        }
        return mode;
    }

    public static int getFreePort() {
        int port = -1;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException iOException) {}
        return port;
    }

    public static boolean setPeerError(final IPeerNode peerNode, final String error) {
        final AtomicBoolean changed = new AtomicBoolean();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                changed.set(peerNode.setProperty("Error", error));
            }
        });
        return changed.get();
    }

    public static String getPeerError(final IPeerNode peerNode) {
        final AtomicReference error = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                error.set(peerNode.getStringProperty("Error"));
            }
        });
        if (error.get() != null && ((String)error.get()).trim().length() > 0) {
            return (String)error.get();
        }
        return null;
    }

    public static Map<String, String> getPeerWarnings(final IPeerNode peerNode) {
        final AtomicReference warnings = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                warnings.set(peerNode.getProperty("Warnings"));
            }
        });
        if (warnings.get() != null && warnings.get() instanceof Map) {
            return (Map)warnings.get();
        }
        return null;
    }

    public static boolean setPeerWarning(final IPeerNode peerNode, final String key, final String value) {
        final AtomicBoolean changed = new AtomicBoolean();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> warnings = (HashMap<String, String>)peerNode.getProperty("Warnings");
                if (warnings == null) {
                    if (value == null) {
                        return;
                    }
                    warnings = new HashMap<String, String>();
                }
                if (value != null) {
                    changed.set(!value.equals(warnings.get(key)));
                    warnings.put(key, value);
                } else {
                    changed.set(warnings.get(key) != null);
                    warnings.remove(key);
                    if (warnings.isEmpty()) {
                        warnings = null;
                    }
                }
                peerNode.setChangeEventsEnabled(false);
                peerNode.setProperty("Warnings", warnings);
                peerNode.setChangeEventsEnabled(true);
            }
        });
        peerNode.fireChangeEvent("Warnings", null, null);
        return changed.get();
    }

    public static String getPeerWarningOrigin(final IPeerNode peerNode, String warningKey) {
        final AtomicReference warningOrigins = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                warningOrigins.set(peerNode.getProperty("WarningOrigins"));
            }
        });
        if (warningOrigins.get() != null && warningOrigins.get() instanceof Map) {
            return (String)((Map)warningOrigins.get()).get(warningKey);
        }
        return null;
    }

    public static boolean setPeerWarningOrigin(final IPeerNode peerNode, final String warningKey, final String value) {
        final AtomicBoolean changed = new AtomicBoolean();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> warningsOrigins = (HashMap<String, String>)peerNode.getProperty("WarningOrigins");
                if (warningsOrigins == null) {
                    if (value == null) {
                        return;
                    }
                    warningsOrigins = new HashMap<String, String>();
                }
                if (value != null) {
                    changed.set(!value.equals(warningsOrigins.get(warningKey)));
                    warningsOrigins.put(warningKey, value);
                } else {
                    changed.set(warningsOrigins.get(warningKey) != null);
                    warningsOrigins.remove(warningKey);
                    if (warningsOrigins.isEmpty()) {
                        warningsOrigins = null;
                    }
                }
                peerNode.setChangeEventsEnabled(false);
                peerNode.setProperty("WarningOrigins", warningsOrigins);
                peerNode.setChangeEventsEnabled(true);
            }
        });
        peerNode.fireChangeEvent("WarningOrigins", null, null);
        return changed.get();
    }
}

