/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.concurrent.executors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.tcf.te.runtime.concurrent.executors.AbstractDelegatingExecutorService;
import org.eclipse.tcf.te.runtime.concurrent.factories.SingleThreadThreadFactory;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.INestableExecutor;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.ISingleThreadedExecutor;

public class SingleThreadedExecutorService
extends AbstractDelegatingExecutorService
implements ISingleThreadedExecutor,
INestableExecutor {
    private SingleThreadThreadFactory threadFactory;

    @Override
    protected ExecutorService createExecutorServiceDelegate() {
        this.threadFactory = new SingleThreadThreadFactory(this.getThreadPoolNamePrefix());
        return new SingleThreadedExecutor(this.threadFactory);
    }

    @Override
    public final boolean isExecutorThread() {
        return this.isExecutorThread(Thread.currentThread());
    }

    @Override
    public final boolean isExecutorThread(Thread thread) {
        if (thread != null && this.threadFactory != null) {
            return thread.equals(this.threadFactory.getThread());
        }
        return false;
    }

    @Override
    public int getMaxDepth() {
        if (!(this.getExecutorServiceDelegate() instanceof INestableExecutor)) {
            throw new UnsupportedOperationException("Executor service delegate must implement INestableExecutor");
        }
        return ((INestableExecutor)((Object)this.getExecutorServiceDelegate())).getMaxDepth();
    }

    @Override
    public boolean readAndExecute() {
        if (!(this.getExecutorServiceDelegate() instanceof INestableExecutor)) {
            throw new UnsupportedOperationException("Executor service delegate must implement INestableExecutor");
        }
        return ((INestableExecutor)((Object)this.getExecutorServiceDelegate())).readAndExecute();
    }

    protected class SingleThreadedExecutor
    extends ThreadPoolExecutor
    implements INestableExecutor {
        private final AtomicInteger currentNestingDepth;

        public SingleThreadedExecutor(ThreadFactory threadFactory) {
            this(threadFactory, new LinkedBlockingQueue<Runnable>());
        }

        private SingleThreadedExecutor(ThreadFactory threadFactory, BlockingQueue<Runnable> workQueue) {
            super(1, 1, 0L, TimeUnit.NANOSECONDS, workQueue, threadFactory);
            this.currentNestingDepth = new AtomicInteger(0);
        }

        @Override
        public int getMaxDepth() {
            return 1;
        }

        @Override
        public boolean readAndExecute() {
            if (!SingleThreadedExecutorService.this.isExecutorThread()) {
                throw new IllegalStateException("Must be called from within the executor thread!");
            }
            BlockingQueue<Runnable> queue = this.getQueue();
            if (!queue.isEmpty()) {
                if (this.currentNestingDepth.get() >= this.getMaxDepth()) {
                    throw new IllegalStateException("Maximum nesting depth exceeded!");
                }
                Runnable runnable = null;
                try {
                    if (!queue.isEmpty()) {
                        runnable = queue.take();
                    }
                }
                catch (InterruptedException interruptedException) {}
                if (runnable != null) {
                    this.currentNestingDepth.incrementAndGet();
                    try {
                        runnable.run();
                    }
                    finally {
                        this.currentNestingDepth.decrementAndGet();
                    }
                }
            }
            return !queue.isEmpty();
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                SingleThreadedExecutorService.this.logException(t);
            }
        }
    }
}

