/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.model.services;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;

public class PropertiesAccessService
extends AbstractService
implements IPropertiesAccessService {
    public Map<String, String> getTargetAddress(Object context) {
        return null;
    }

    public Object getProperty(Object context, final String key) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)key);
        final AtomicReference value = new AtomicReference();
        if (context instanceof IPropertiesContainer) {
            final IPropertiesContainer node = (IPropertiesContainer)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object val = node.getProperty(key);
                    value.set(val);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return value.get();
    }

    public boolean setProperty(Object context, final String key, final Object value) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)key);
        final AtomicBoolean result = new AtomicBoolean();
        if (context instanceof IPropertiesContainer) {
            final IPropertiesContainer node = (IPropertiesContainer)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    result.set(node.setProperty(key, value));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return result.get();
    }

    public boolean isProperty(Object context, final String key, final Object value) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)key);
        final AtomicBoolean result = new AtomicBoolean();
        if (context instanceof IPropertiesContainer) {
            final IPropertiesContainer node = (IPropertiesContainer)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    result.set(node.isProperty(key, value));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return result.get();
    }

    public Object getParent(Object context) {
        Assert.isNotNull((Object)context);
        final AtomicReference value = new AtomicReference();
        if (context instanceof IContainerModelNode) {
            final IContainerModelNode node = (IContainerModelNode)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    value.set(node.getParent());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return value.get();
    }
}

