/*******************************************************************************
 * Copyright (c) 2007, 2011 Wind River Systems, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * You may elect to redistribute this code under either of these licenses.
 *
 * Contributors:
 *     Wind River Systems - initial API and implementation
 *******************************************************************************/

/*
 * This module handles process/thread OS contexts and their state machine.
 */

#ifndef D_context_win32
#define D_context_win32

#include <tcf/config.h>
#include <tcf/framework/context.h>

extern HANDLE get_context_handle(Context * ctx);
extern HANDLE get_context_file_handle(Context * ctx);
extern HANDLE get_context_module_handle(Context * ctx);

extern DWORD64 get_context_base_address(Context * ctx);
extern DWORD64 get_context_module_address(Context * ctx);

typedef int ContextExceptionHandler(Context *, EXCEPTION_DEBUG_INFO *);
extern void add_context_exception_handler(ContextExceptionHandler * h);

#endif /* D_context_win32 */
