/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.jface.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.tcf.te.ui.swt.activator.UIPlugin;
import org.eclipse.tcf.te.ui.swt.nls.Messages;
import org.eclipse.ui.PlatformUI;

public class OptionalMessageDialog
extends MessageDialogWithToggle {
    private static final String DIALOG_ID = "OptionalMessageDialog";
    private String contextHelpId;
    private String key;

    public OptionalMessageDialog(Shell parentShell, String title, Image image, String message, int imageType, String[] buttonLabels, int defaultIndex, String key, String contextHelpId) {
        String[] stringArray;
        if (buttonLabels != null) {
            stringArray = buttonLabels;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = IDialogConstants.OK_LABEL;
        }
        super(parentShell, title, image, message, imageType, stringArray, defaultIndex, Messages.getString(DIALOG_ID + (imageType == 3 ? "_rememberMyDecision_label" : "_doNotShowAgain_label")), false);
        this.contextHelpId = contextHelpId;
        String string = this.key = key == null || key.trim().length() == 0 ? null : key.trim();
        if (contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, contextHelpId);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1024, true, false);
        if (parent.getLayout() instanceof GridLayout) {
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        if (this.contextHelpId != null) {
            Control helpControl = this.createHelpControl(composite);
            ((GridData)helpControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        }
        Control buttonSection = super.createButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, this.adjustButtonIdForLabel(id, label), label, defaultButton);
    }

    protected int adjustButtonIdForLabel(int id, String label) {
        return id;
    }

    private Control createHelpControl(Composite parent) {
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage != null) {
            return this.createHelpImageButton(parent, helpImage);
        }
        return this.createHelpLink(parent);
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalMessageDialog.this.helpPressed();
            }
        });
        return toolBar;
    }

    private Link createHelpLink(Composite parent) {
        Link link = new Link(parent, 524352);
        ++((GridLayout)parent.getLayout()).numColumns;
        link.setLayoutData((Object)new GridData(64));
        link.setText("<a>" + IDialogConstants.HELP_LABEL + "</a>");
        link.setToolTipText(IDialogConstants.HELP_LABEL);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalMessageDialog.this.helpPressed();
            }
        });
        return link;
    }

    void helpPressed() {
        if (this.getShell() != null) {
            Control c = this.getShell().getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    c.notifyListeners(28, new Event());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    protected Control createCustomArea(Composite parent) {
        if (this.contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextHelpId);
        }
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        return label;
    }

    public int open() {
        int result = OptionalMessageDialog.getDialogResult(this.key);
        if (result < 0) {
            result = super.open();
            if (this.getToggleState() && this.storeResultOnToggleSelected(result)) {
                OptionalMessageDialog.setDialogResult(this.key, result);
            }
        }
        return result;
    }

    protected boolean storeResultOnToggleSelected(int result) {
        return result >= 0 && result != 1;
    }

    protected void setToggleButton(Button button) {
        if (button != null && this.key != null) {
            super.setToggleButton(button);
        }
    }

    protected Button createToggleButton(Composite parent) {
        if (this.key != null) {
            return super.createToggleButton(parent);
        }
        return null;
    }

    public static int openOkCancelDialog(Shell parentShell, String title, String message, String key, String contextHelpId) {
        return OptionalMessageDialog.openOkCancelDialog(parentShell, title, message, null, key, contextHelpId);
    }

    public static int openOkCancelDialog(Shell parentShell, String title, String message, String[] buttonLabel, String key, String contextHelpId) {
        if (buttonLabel == null) {
            buttonLabel = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(parentShell, title, null, message, 3, buttonLabel, 0, key, contextHelpId);
        return dialog.open();
    }

    public static int openYesNoCancelDialog(Shell parentShell, String title, String message, String key, String contextHelpId) {
        return OptionalMessageDialog.openYesNoCancelDialog(parentShell, title, message, null, key, contextHelpId);
    }

    public static int openYesNoCancelDialog(Shell parentShell, String title, String message, String[] buttonLabel, String key, String contextHelpId) {
        if (buttonLabel == null) {
            buttonLabel = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(parentShell, title, null, message, 3, buttonLabel, 0, key, contextHelpId);
        return dialog.open();
    }

    public static int openYesNoDialog(Shell parentShell, String title, String message, String key, String contextHelpId) {
        return OptionalMessageDialog.openYesNoDialog(parentShell, title, message, null, key, contextHelpId);
    }

    public static int openYesNoDialog(Shell parentShell, String title, String message, String[] buttonLabel, String key, String contextHelpId) {
        if (buttonLabel == null) {
            buttonLabel = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(parentShell, title, null, message, 3, buttonLabel, 0, key, contextHelpId);
        return dialog.open();
    }

    public static int openInformationDialog(Shell parentShell, String title, String message, String key, String contextHelpId) {
        return OptionalMessageDialog.openInformationDialog(parentShell, title, message, null, key, contextHelpId);
    }

    public static int openInformationDialog(Shell parentShell, String title, String message, String[] buttonLabel, String key, String contextHelpId) {
        if (buttonLabel == null) {
            buttonLabel = new String[]{IDialogConstants.OK_LABEL};
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(parentShell, title, null, message, 2, buttonLabel, 0, key, contextHelpId);
        return dialog.open();
    }

    public static int openWarningDialog(Shell parentShell, String title, String message, String key, String contextHelpId) {
        return OptionalMessageDialog.openWarningDialog(parentShell, title, message, null, key, contextHelpId);
    }

    public static int openWarningDialog(Shell parentShell, String title, String message, String[] buttonLabel, String key, String contextHelpId) {
        if (buttonLabel == null) {
            buttonLabel = new String[]{IDialogConstants.OK_LABEL};
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(parentShell, title, null, message, 4, buttonLabel, 0, key, contextHelpId);
        return dialog.open();
    }

    public static int openErrorDialog(Shell parentShell, String title, String message, String key, String contextHelpId) {
        return OptionalMessageDialog.openErrorDialog(parentShell, title, message, null, key, contextHelpId);
    }

    public static int openErrorDialog(Shell parentShell, String title, String message, String[] buttonLabel, String key, String contextHelpId) {
        if (buttonLabel == null) {
            buttonLabel = new String[]{IDialogConstants.OK_LABEL};
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(parentShell, title, null, message, 1, buttonLabel, 0, key, contextHelpId);
        return dialog.open();
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = UIPlugin.getDefault().getDialogSettings();
        if ((settings = settings.getSection(DIALOG_ID)) == null) {
            settings = UIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_ID);
        }
        return settings;
    }

    public static int getDialogResult(String key) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        try {
            return settings.getInt(String.valueOf(key) + ".result");
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static boolean getDialogToggleState(String key) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        return settings.getBoolean(String.valueOf(key) + ".toggleState");
    }

    public static String getAdditionalDialogInfo(String key) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        return settings.get(String.valueOf(key) + ".additionalInfo");
    }

    public static void setDialogResult(String key, int result) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        if (result < 0) {
            settings.put(String.valueOf(key) + ".result", "prompt");
        } else {
            settings.put(String.valueOf(key) + ".result", result);
        }
    }

    public static void setDialogToggleState(String key, boolean state) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        settings.put(String.valueOf(key) + ".toggleState", state);
    }

    public static void setAdditionalDialogInfo(String key, String value) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        settings.put(String.valueOf(key) + ".additionalInfo", value);
    }

    public static void clearAllRememberedStates() {
        IDialogSettings settings = UIPlugin.getDefault().getDialogSettings();
        settings.addNewSection(DIALOG_ID);
    }
}

