/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.model;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.core.interfaces.IConnectable;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.runtime.model.factory.Factory;
import org.eclipse.tcf.te.runtime.model.interfaces.factory.IFactory;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDelegateService;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelService;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.UserAccount;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCopyLocal;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpParsePath;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRestoreFavorites;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class RuntimeModel
extends ContainerModelNode
implements IRuntimeModel,
IChannel.IChannelListener {
    private final IPeerNode fPeerNode;
    private final FSTreeNode fRoot;
    private final UserAccount fUserAccount;
    private IChannel fChannel;
    private IFileSystem fFileSystem;
    private IRuntimeModel.Delegate fDelegate;

    public RuntimeModel(IPeerNode peerNode, IChannel channel, IFileSystem fileSystem, UserAccount userAccount) {
        this.fPeerNode = peerNode;
        this.fChannel = channel;
        this.fFileSystem = fileSystem;
        this.fUserAccount = userAccount;
        this.fRoot = new FSTreeNode(this, Messages.FSTreeNodeContentProvider_rootNodeLabel);
        channel.addChannelListener((IChannel.IChannelListener)this);
        this.fDelegate = this.findDelegate();
    }

    private IRuntimeModel.Delegate findDelegate() {
        IService[] services;
        IService[] iServiceArray = services = ServiceManager.getInstance().getServices((Object)this.fPeerNode, IDelegateService.class, false);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IService service = iServiceArray[n2];
            IRuntimeModel.Delegate cand = (IRuntimeModel.Delegate)((IDelegateService)service).getDelegate((Object)this, IRuntimeModel.Delegate.class);
            if (cand != null) {
                return cand;
            }
            ++n2;
        }
        return new IRuntimeModel.Delegate();
    }

    protected boolean checkThreadAccess() {
        return Protocol.isDispatchThread();
    }

    public void onChannelOpened() {
    }

    public void congestionLevel(int level) {
    }

    public void onChannelClosed(Throwable error) {
        ModelManager.disposeRuntimeModel(this.fPeerNode);
    }

    public void dispose() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.fFileSystem = null;
        this.fRoot.setContent(new FSTreeNode[0], false);
    }

    public boolean isDisposed() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.fFileSystem == null;
    }

    public <V extends IModelService> V getService(Class<V> serviceInterface) {
        Assert.isNotNull(serviceInterface);
        return (V)((IModelService)this.getAdapter(serviceInterface));
    }

    @Override
    public IRuntimeModel.Delegate getDelegate() {
        return this.fDelegate;
    }

    public Object getAdapter(Class adapter) {
        if (IPeerNode.class.isAssignableFrom(adapter) || IConnectable.class.isAssignableFrom(adapter)) {
            final AtomicReference peerNode = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    peerNode.set(RuntimeModel.this.getPeerNode());
                }
            });
            return peerNode.get();
        }
        return super.getAdapter(adapter);
    }

    public void setFactory(IFactory factory) {
    }

    public IFactory getFactory() {
        return Factory.getInstance();
    }

    public IPeerNode getPeerNode() {
        return this.fPeerNode;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "*DISPOSED* : " + super.toString();
        }
        return super.toString();
    }

    @Override
    public FSTreeNode getRoot() {
        return this.fRoot;
    }

    public UserAccount getUserAccount() {
        return this.fUserAccount;
    }

    public void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        IPropertyChangeProvider provider = (IPropertyChangeProvider)this.fPeerNode.getAdapter(IPropertyChangeProvider.class);
        if (provider != null) {
            provider.firePropertyChange(propertyChangeEvent);
        }
    }

    @Override
    public IOperation operationDownload(List<IFSTreeNode> nodes, File destination, IConfirmCallback confirmCallback) {
        return new OpCopyLocal(nodes, destination, confirmCallback);
    }

    @Override
    public IResultOperation<IFSTreeNode> operationRestoreFromPath(String path) {
        return new OpParsePath(this.fPeerNode, path);
    }

    public static IPeerNode getPeerFromPath(String path) {
        String cacheRoot = CacheManager.getCacheRoot().getAbsolutePath();
        if (!path.startsWith(cacheRoot)) {
            return null;
        }
        int slash = (path = path.substring(cacheRoot.length() + 1)).indexOf(File.separator);
        if (slash == -1) {
            return null;
        }
        String peerId = path.substring(0, slash);
        peerId = peerId.replace('$', ':');
        IPeerNode[] iPeerNodeArray = org.eclipse.tcf.te.tcf.locator.model.ModelManager.getPeerModel().getPeerNodes();
        int n = iPeerNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode peer = iPeerNodeArray[n2];
            if (peerId.equals(peer.getPeerId())) {
                return peer;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IResultOperation<IFSTreeNode[]> operationRestoreFavorites() {
        return new OpRestoreFavorites(this);
    }

    @Override
    public IChannel getChannel() {
        return this.fChannel;
    }

    public IFileSystem getFileSystem() {
        return this.fFileSystem;
    }
}

