/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.wst.validation.ValidationFramework;
import org.osgi.framework.Bundle;

public abstract class AbstractProjectSuite
extends TestSuite {
    public static final String WORKSPACE_BASE = "workspace";
    private Bundle bundle;

    public AbstractProjectSuite(String name, Bundle bundle) {
        super(name);
        this.bundle = bundle;
    }

    public AbstractProjectSuite(String name) {
        this(name, PHPCoreTests.getDefault().getBundle());
    }

    protected IProject setUpProject(String projectName) throws CoreException, IOException {
        File sourceWorkspacePath = this.getSourceWorkspacePath();
        File targetWorkspacePath = this.getWorkspaceRoot().getLocation().toFile();
        this.copyDirectory(new File(sourceWorkspacePath, projectName), new File(targetWorkspacePath, projectName));
        return this.createProject(projectName);
    }

    protected IScriptProject setUpScriptProjectTo(String projectName, String fromName) throws CoreException, IOException {
        IProject project = this.setUpProjectTo(projectName, fromName);
        return DLTKCore.create((IProject)project);
    }

    protected IProject setUpProjectTo(String projectName, String fromName) throws CoreException, IOException {
        File sourceWorkspacePath = this.getSourceWorkspacePath();
        File targetWorkspacePath = this.getWorkspaceRoot().getLocation().toFile();
        this.copyDirectory(new File(sourceWorkspacePath, fromName), new File(targetWorkspacePath, projectName));
        return this.createProject(projectName);
    }

    protected IScriptProject setUpScriptProject(String projectName) throws CoreException, IOException {
        IProject project = this.setUpProject(projectName);
        return DLTKCore.create((IProject)project);
    }

    public ISourceModule getSourceModule(String projectName, String rootPath, IPath path) throws ModelException {
        IScriptFolder folder = this.getScriptFolder(projectName, rootPath, path.removeLastSegments(1));
        if (folder == null) {
            return null;
        }
        return folder.getSourceModule(path.lastSegment());
    }

    public ISourceModule getSourceModule(String projectName, String rootPath, String path) throws ModelException {
        IScriptFolder folder = this.getScriptFolder(projectName, rootPath, new Path(path).removeLastSegments(1));
        if (folder == null) {
            return null;
        }
        return folder.getSourceModule(new Path(path).lastSegment().toString());
    }

    public IScriptFolder getScriptFolder(String projectName, String fragmentPath, IPath path) throws ModelException {
        IProjectFragment root = this.getProjectFragment(projectName, fragmentPath);
        if (root == null) {
            return null;
        }
        return root.getScriptFolder(path);
    }

    public IProjectFragment getProjectFragment(String projectName, String fragmentPath) throws ModelException {
        IScriptProject project = this.getScriptProject(projectName);
        if (project == null) {
            return null;
        }
        Path path = new Path(fragmentPath);
        if (path.isAbsolute()) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = workspaceRoot.findMember((IPath)path);
            IProjectFragment root = project.getProjectFragment(resource);
            return root;
        }
        IProjectFragment[] roots = project.getProjectFragments();
        if (roots == null || roots.length == 0) {
            return null;
        }
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            if (root.getUnderlyingResource().getProjectRelativePath().equals((Object)path)) {
                return root;
            }
            ++i;
        }
        return null;
    }

    public IScriptProject getScriptProject(String name) {
        IProject project = this.getProject(name);
        return DLTKCore.create((IProject)project);
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    protected IProject getProject(String project) {
        return this.getWorkspaceRoot().getProject(project);
    }

    public File getSourceWorkspacePath() {
        return new File(this.getPluginDirectoryPath(), WORKSPACE_BASE);
    }

    protected File getPluginDirectoryPath() {
        try {
            URL platformURL = this.bundle.getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void copyDirectory(File source, File target) throws IOException {
        File[] files;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.listFiles()) == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File sourceChild = files[i];
            String name = sourceChild.getName();
            if (!name.equals("CVS") && !name.equals(".svn")) {
                File targetChild = new File(target, name);
                if (sourceChild.isDirectory()) {
                    this.copyDirectory(sourceChild, targetChild);
                } else {
                    AbstractProjectSuite.copy(sourceChild, targetChild);
                }
            }
            ++i;
        }
    }

    public static void copy(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buffer = new byte[12288];
        try {
            in = new FileInputStream(src);
            try {
                int read;
                out = new FileOutputStream(dest);
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    protected IProject createProject(String projectName) throws CoreException {
        final IProject project = this.getProject(projectName);
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(null);
                project.open(null);
            }
        };
        this.getWorkspace().run(create, null);
        ValidationFramework.getDefault().suspendValidation(project, true);
        return project;
    }

    protected IScriptProject createScriptProject(String projectName, String[] natures, String[] sourceFolders) throws CoreException {
        return this.createScriptProject(projectName, natures, sourceFolders, null);
    }

    protected IScriptProject createScriptProject(final String projectName, final String[] natures, final String[] sourceFolders, final String[] projects) throws CoreException {
        final IScriptProject[] result = new IScriptProject[1];
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AbstractProjectSuite.this.createProject(projectName);
                IProject project = AbstractProjectSuite.this.getWorkspaceRoot().getProject(projectName);
                IProjectDescription description = project.getDescription();
                description.setNatureIds(natures);
                project.setDescription(description, null);
                IPath projectPath = project.getFullPath();
                int sourceLength = sourceFolders == null ? 0 : sourceFolders.length;
                int projectLength = projects == null ? 0 : projects.length;
                IBuildpathEntry[] entries = new IBuildpathEntry[sourceLength + projectLength];
                int i = 0;
                while (i < sourceLength) {
                    Path sourcePath = new Path(sourceFolders[i]);
                    int segmentCount = sourcePath.segmentCount();
                    if (segmentCount > 0) {
                        IProject container = project;
                        int j = 0;
                        while (j < segmentCount) {
                            IFolder folder = container.getFolder((IPath)new Path(sourcePath.segment(j)));
                            if (!folder.exists()) {
                                folder.create(true, true, null);
                            }
                            container = folder;
                            ++j;
                        }
                    }
                    entries[i] = DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)sourcePath));
                    ++i;
                }
                i = 0;
                while (i < projectLength) {
                    IPath[] accessibleFiles = new IPath[]{};
                    IPath[] nonAccessibleFiles = new IPath[]{};
                    entries[sourceLength + i] = DLTKCore.newProjectEntry((IPath)new Path(projects[i]), (IAccessRule[])BuildpathEntry.getAccessRules((IPath[])accessibleFiles, (IPath[])nonAccessibleFiles), (boolean)true, (IBuildpathAttribute[])new IBuildpathAttribute[0], (boolean)false);
                    ++i;
                }
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                scriptProject.setRawBuildpath(entries, null);
                result[0] = scriptProject;
            }
        };
        this.getWorkspace().run(create, null);
        return result[0];
    }

    public static void waitUntilIndexesReady() {
        ModelManager.getModelManager().getIndexManager().waitUntilReady();
    }

    protected void deleteProject(String projectName) throws CoreException {
        IProject project = this.getProject(projectName);
        if (project.exists() && !project.isOpen()) {
            project.open(null);
        }
        this.deleteResource((IResource)project);
    }

    public void deleteResource(IResource resource) throws CoreException {
        CoreException lastException = null;
        try {
            resource.delete(true, null);
        }
        catch (CoreException e) {
            lastException = e;
            System.out.println(e.getMessage());
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        int retryCount = 60;
        while (resource.isAccessible() && --retryCount >= 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                lastException = e;
                System.out.println("Retry " + retryCount + ": " + e.getMessage());
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Retry " + retryCount + ": " + iae.getMessage());
            }
        }
        if (!resource.isAccessible()) {
            return;
        }
        System.err.println("Failed to delete " + String.valueOf(resource.getFullPath()));
        if (lastException != null) {
            throw lastException;
        }
    }
}

