/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.tests.TestUtils;

public class TestProject {
    private static int fCounter = 0;
    private IProject fProject;

    public TestProject() {
        this("TestProject_" + fCounter++);
    }

    public TestProject(String name) {
        this.createProject(name);
    }

    private void createProject(String name) {
        this.fProject = TestUtils.createProject((String)name);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void delete() throws Exception {
        TestUtils.deleteProject((IProject)this.fProject);
    }

    public IFile createFile(String path, String content) throws CoreException {
        Path filePath = new Path(path);
        if (filePath.segmentCount() > 1) {
            this.createFolder(filePath.removeLastSegments(1));
        }
        ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
        IFile file = this.fProject.getFile(path);
        if (!file.exists()) {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        return file;
    }

    private IFolder createFolder(IPath path) throws CoreException {
        IFolder folder = this.fProject.getFolder(path);
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return folder;
    }

    public IFile findFile(String path) {
        return this.fProject.getFile(path);
    }

    public IFolder createFolder(String path) throws CoreException {
        IFolder folder = this.fProject.getFolder(path);
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return folder;
    }
}

