/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.test;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.Activator;
import org.eclipse.php.refactoring.core.test.FileInfo;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.eclipse.php.refactoring.core.test.TestProject;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public abstract class AbstractPDTTListRefactoringTest
extends AbstractRefactoringTest {
    protected String[] fileNames = null;
    protected TestProject project;
    protected Map<String, PdttFileExt> filesMap = new LinkedHashMap<String, PdttFileExt>();

    public AbstractPDTTListRefactoringTest(String[] fileNames) {
        this.fileNames = fileNames;
    }

    private TestProject createProject() {
        return new TestProject();
    }

    @PDTTList.BeforeList
    public void setUpListSuite() throws Exception {
        this.project = this.createProject();
        ResourcesPlugin.getWorkspace().run(m -> {
            try {
                this.initFiles(this.fileNames);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                Assert.fail();
            }
        }, null);
        TestUtils.waitForIndexer();
    }

    @PDTTList.AfterList
    public void tearDownListSuite() throws Exception {
        this.project.delete();
    }

    protected void initFiles(String[] fileNames) throws Exception {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            PdttFileExt pdttFile = new PdttFileExt(AbstractPDTTListRefactoringTest.getBundle(), fileName);
            for (FileInfo testFile : pdttFile.getTestFiles()) {
                this.project.createFile(testFile.getName(), this.getContents(pdttFile, testFile));
            }
            this.filesMap.put(fileName, pdttFile);
            ++n2;
        }
    }

    protected String getContents(PdttFileExt pdttFile, FileInfo testFile) {
        Object data = testFile.getContents();
        int offset = ((String)data).lastIndexOf(124);
        if (offset < 0) {
            return data;
        }
        pdttFile.getConfig().put("start", String.valueOf(offset));
        data = ((String)data).substring(0, offset) + ((String)data).substring(offset + 1);
        return data;
    }

    protected void checkTestResult(PdttFileExt pdttFile) {
        TestUtils.waitForIndexer();
        List<FileInfo> files = pdttFile.getExpectedFiles();
        for (FileInfo expFile : files) {
            IFile file = this.project.findFile(expFile.getName());
            Assert.assertTrue((boolean)file.exists());
            try {
                PDTTUtils.assertContents((String)this.getContents(pdttFile, expFile), (String)FileUtils.getContents(file));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }
}

