/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueInputDialog;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractVariableValueEditor
implements IVariableValueEditor {
    protected abstract String getValueString(IVariable var1) throws DebugException;

    public boolean editVariable(IVariable variable, Shell shell) {
        try {
            String name = variable.getName();
            String title = PHPDebugUIMessages.AbstractVariableValueEditor_ChangeValueTitle;
            String message = MessageFormat.format(PHPDebugUIMessages.AbstractVariableValueEditor_EnterValue, name);
            String initialValue = this.getValueString(variable);
            ValueValidator validator = new ValueValidator(variable);
            ChangeVariableValueInputDialog dialog = new ChangeVariableValueInputDialog(shell, title, message, initialValue, (IInputValidator)validator);
            if (dialog.open() == 0) {
                String stringValue = dialog.getValue();
                variable.setValue(stringValue);
            }
        }
        catch (DebugException e) {
            IStatus status = e.getStatus();
            ErrorDialog.openError((Shell)shell, (String)PHPDebugUIMessages.AbstractVariableValueEditor_ErrorChangingValue, (String)PHPDebugUIMessages.AbstractVariableValueEditor_UnexpectedErrorWhileValueChange, (IStatus)status);
        }
        return true;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        return false;
    }

    protected class ValueValidator
    implements IInputValidator {
        IVariable variable;

        public ValueValidator(IVariable variable) {
            this.variable = variable;
        }

        public String isValid(String value) {
            String errorMsg = null;
            try {
                if (!this.variable.verifyValue(value)) {
                    errorMsg = PHPDebugUIMessages.AbstractVariableValueEditor_InvalidValue;
                }
            }
            catch (DebugException e) {
                Logger.logException(e);
                errorMsg = PHPDebugUIMessages.AbstractVariableValueEditor_UnexpectedError;
            }
            return errorMsg;
        }
    }
}

