/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpDebugTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.TimedEvent;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;

public class DBGpMultiSessionTarget
extends DBGpElement
implements IPHPDebugTarget,
IDBGpDebugTarget,
IDBGpSessionListener,
IDebugEventSetListener,
IStepFilters {
    private String sessionID;
    private String ideKey;
    private boolean webLaunch = false;
    private IProcess process;
    private String stopDebugURL;
    private volatile int targetState;
    private static final int STATE_INIT_SESSION_WAIT = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_TERMINATING = 2;
    private static final int STATE_TERMINATED = 3;
    private String scriptName;
    private ILaunch launch;
    private DBGpBreakpointFacade bpFacade;
    private DBGpPreferences sessionPreferences;
    private TimedEvent te = new TimedEvent();
    private boolean stopAtStart;
    private ArrayList<DBGpTarget> debugTargets = new ArrayList();
    private PathMapper pathMapper;
    private DebugOutput debugOutput = new DebugOutput();

    private DBGpMultiSessionTarget() {
        super(null);
        this.ideKey = DBGpSessionHandler.getInstance().getIDEKey();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fireCreationEvent();
        this.targetState = 0;
    }

    public DBGpMultiSessionTarget(ILaunch launch, String workspaceRelativeScript, String stopDebugURL, String ideKey, boolean stopAtStart) {
        this();
        this.stopAtStart = stopAtStart;
        this.launch = launch;
        this.scriptName = workspaceRelativeScript;
        this.ideKey = ideKey;
        this.webLaunch = true;
        this.sessionID = null;
        this.createMockProcess(launch, stopDebugURL);
    }

    private void createMockProcess(ILaunch launch, String stopDebugURL) {
        this.stopDebugURL = stopDebugURL;
        this.process = new PHPProcess(launch, PHPDebugCoreMessages.DBGpMultiSessionTarget_Multisession_PHP_process);
        this.process.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.php.debug.core.launching.PHPProcess");
        ((PHPProcess)this.process).setDebugTarget(this);
        launch.addProcess(this.process);
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getName() throws DebugException {
        return PHPDebugCoreMessages.XDebug_DBGpMultiSessionTarget_0;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess proc) {
        this.process = proc;
    }

    public IThread[] getThreads() throws DebugException {
        ArrayList<IThread> threads = new ArrayList<IThread>();
        for (IPHPDebugTarget iPHPDebugTarget : this.debugTargets) {
            if (!iPHPDebugTarget.hasThreads()) continue;
            IThread[] iThreadArray = iPHPDebugTarget.getThreads();
            int n = iThreadArray.length;
            int n2 = 0;
            while (n2 < n) {
                IThread thread = iThreadArray[n2];
                threads.add(thread);
                ++n2;
            }
        }
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        for (IPHPDebugTarget iPHPDebugTarget : this.debugTargets) {
            if (!iPHPDebugTarget.hasThreads()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            if (this.debugTargets.size() > 0) {
                IDebugTarget firstTarget = this.debugTargets.get(0);
                return firstTarget.supportsBreakpoint(breakpoint);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        boolean isSuspended = false;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.debugTargets.size() && !isSuspended) {
                IDebugTarget target = this.debugTargets.get(i);
                isSuspended |= target.isSuspended();
                ++i;
            }
        }
        return isSuspended;
    }

    public boolean isTerminated() {
        return this.targetState == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        if (this.targetState == 2) {
            ArrayList<DBGpTarget> arrayList = this.debugTargets;
            synchronized (arrayList) {
                if (this.debugTargets.size() > 0) {
                    int i = 0;
                    while (i < this.debugTargets.size()) {
                        IDebugTarget target = this.debugTargets.get(i);
                        try {
                            target.terminate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                this.terminateMultiSessionDebugTarget();
            }
            return;
        }
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            DBGpSessionHandler.getInstance().removeSessionListener(this);
            this.targetState = 2;
            if (this.debugTargets.size() > 0) {
                int i = 0;
                while (i < this.debugTargets.size()) {
                    IDebugTarget target = this.debugTargets.get(i);
                    if (target.canTerminate()) {
                        target.terminate();
                    }
                    ++i;
                }
            } else {
                this.terminateMultiSessionDebugTarget();
            }
        }
    }

    public boolean canDisconnect() {
        boolean canDisconnect = false;
        return canDisconnect;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean canTerminate() {
        boolean canTerminate = this.targetState == 1 || this.targetState == 0;
        return canTerminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canResume() {
        boolean canResume = false;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.debugTargets.size() && !canResume) {
                IDebugTarget target = this.debugTargets.get(i);
                canResume |= target.canResume();
                ++i;
            }
        }
        return canResume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSuspend() {
        boolean canSuspend = false;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.debugTargets.size() && !canSuspend) {
                IDebugTarget target = this.debugTargets.get(i);
                canSuspend |= target.canSuspend();
                ++i;
            }
        }
        return canSuspend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.debugTargets.size()) {
                IDebugTarget target = this.debugTargets.get(i);
                if (target.canResume()) {
                    target.resume();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.debugTargets.size()) {
                IDebugTarget target = this.debugTargets.get(i);
                if (target.canSuspend()) {
                    target.suspend();
                }
                ++i;
            }
        }
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    private boolean isTerminating() {
        boolean terminating = this.targetState == 3 || this.targetState == 2;
        return terminating;
    }

    @Override
    public void waitForInitialSession(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs, IProgressMonitor launchMonitor) {
        this.configureInitialState(facade, sessionPrefs);
        try {
            while (!(this.debugTargets.size() != 0 || this.launch.isTerminated() || this.isTerminating() || launchMonitor.isCanceled())) {
                this.te.waitForEvent(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.debugTargets.size() == 0) {
            DBGpSessionHandler.getInstance().removeSessionListener(this);
            this.terminateMultiSessionDebugTarget();
        }
    }

    public void sessionReceived(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs, DBGpTarget owningTarget, PathMapper globalMapper) {
        this.configureInitialState(facade, sessionPrefs);
        owningTarget.setMultiSessionManaged(true);
        this.addDebugTarget(owningTarget);
        this.setPathMapper(globalMapper);
        owningTarget.sessionReceived(facade, sessionPrefs);
    }

    @Override
    public void configureInitialState(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs) {
        this.bpFacade = facade;
        this.sessionPreferences = sessionPrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean SessionCreated(DBGpSession session) {
        boolean accepted = false;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            DBGpTarget target = new DBGpTarget(this.launch, this.scriptName, this.stopDebugURL, this.ideKey, this.sessionID, this.stopAtStart);
            target.setMultiSessionManaged(true);
            target.setPathMapper(this.pathMapper);
            accepted = target.SessionCreated(session);
            if (accepted) {
                target.waitForInitialSession(this.bpFacade, this.sessionPreferences, null);
                if (!target.isTerminated()) {
                    this.addDebugTarget(target);
                    if (this.targetState == 0) {
                        this.targetState = 1;
                        this.te.signalEvent();
                    }
                }
            }
        }
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebugTarget(DBGpTarget target) {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            if (this.debugTargets.size() == 0) {
                this.debugOutput = new DebugOutput();
            }
            this.debugTargets.add(target);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < events.length) {
                int kind;
                DebugEvent evt = events[i];
                Object src = evt.getSource();
                if (src instanceof DBGpTarget && this.debugTargets.contains(src) && (kind = evt.getKind()) == 8) {
                    this.debugTargets.remove(src);
                }
                ++i;
            }
        }
        if (this.targetState == 2 && this.debugTargets.size() == 0) {
            this.terminateMultiSessionDebugTarget();
        }
    }

    private void terminateMultiSessionDebugTarget() {
        if (this.webLaunch) {
            this.sendStopDebugURL();
        }
        this.targetState = 3;
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            this.fireTerminateEvent();
        }
        try {
            this.getLaunch().terminate();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    private void sendStopDebugURL() {
        if (this.stopDebugURL == null) {
            return;
        }
        DBGpLogger.debug("browser is not null, sending " + this.stopDebugURL);
        try {
            PHPDebugUtil.openLaunchURL(this.stopDebugURL, false);
        }
        catch (DebugException e) {
            DBGpLogger.logException("Failed to send stop XDebug session URL: " + this.stopDebugURL, this, e);
        }
    }

    @Override
    public void setPathMapper(PathMapper mapper) {
        this.pathMapper = mapper;
    }

    @Override
    public boolean isWebLaunch() {
        return this.webLaunch;
    }

    @Override
    public DebugOutput getOutputBuffer() {
        return this.debugOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWaiting() {
        boolean isWaiting = this.targetState == 0;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.debugTargets.size() && !isWaiting) {
                IPHPDebugTarget target = this.debugTargets.get(i);
                isWaiting |= target.isWaiting();
                ++i;
            }
        }
        return isWaiting;
    }

    public boolean supportsStepFilters() {
        return !this.isTerminated() && !this.isDisconnected();
    }

    public boolean isStepFiltersEnabled() {
        int i = 0;
        while (i < this.debugTargets.size()) {
            IStepFilters target = (IStepFilters)this.debugTargets.get(i).getAdapter(IStepFilters.class);
            if (target != null && target.isStepFiltersEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepFiltersEnabled(boolean enabled) {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.debugTargets.size()) {
                IStepFilters target = (IStepFilters)this.debugTargets.get(i).getAdapter(IStepFilters.class);
                if (target != null) {
                    target.setStepFiltersEnabled(enabled);
                }
                ++i;
            }
        }
    }
}

